/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core;

import io.undertow.UndertowMessages;
import io.undertow.websockets.core.StreamSinkFrameChannel;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.xnio.channels.Channels;

public final class BinaryOutputStream
extends OutputStream {
    private final StreamSinkFrameChannel sender;
    private boolean closed;

    public BinaryOutputStream(StreamSinkFrameChannel sender) {
        this.sender = sender;
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        this.checkClosed();
        if (Thread.currentThread() == this.sender.getIoThread()) {
            throw UndertowMessages.MESSAGES.awaitCalledFromIoThread();
        }
        Channels.writeBlocking(this.sender, ByteBuffer.wrap(b2, off, len));
    }

    @Override
    public void write(int b2) throws IOException {
        this.checkClosed();
        if (Thread.currentThread() == this.sender.getIoThread()) {
            throw UndertowMessages.MESSAGES.awaitCalledFromIoThread();
        }
        Channels.writeBlocking(this.sender, ByteBuffer.wrap(new byte[]{(byte)b2}));
    }

    @Override
    public void flush() throws IOException {
        this.checkClosed();
        if (Thread.currentThread() == this.sender.getIoThread()) {
            throw UndertowMessages.MESSAGES.awaitCalledFromIoThread();
        }
        this.sender.flush();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.sender.shutdownWrites();
            Channels.flushBlocking(this.sender);
        }
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
    }
}

