/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core.function;

import io.undertow.websockets.core.function.ChannelFunction;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class ChannelFunctionReadableByteChannel
implements ReadableByteChannel {
    private final ChannelFunction[] functions;
    private final ReadableByteChannel channel;

    public ChannelFunctionReadableByteChannel(ReadableByteChannel channel, ChannelFunction ... functions) {
        this.channel = channel;
        this.functions = functions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        int pos = dst.position();
        int r2 = 0;
        try {
            int n2 = r2 = this.channel.read(dst);
            return n2;
        }
        finally {
            if (r2 > 0) {
                for (ChannelFunction func : this.functions) {
                    func.afterRead(dst, pos, r2);
                }
            }
        }
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

