/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.spi;

import io.undertow.server.HttpServerExchange;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.spi.AsyncWebSocketHttpServerExchange;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Set;
import org.xnio.FinishedIoFuture;
import org.xnio.FutureResult;
import org.xnio.IoFuture;

public class BlockingWebSocketHttpServerExchange
extends AsyncWebSocketHttpServerExchange {
    private final OutputStream out;
    private final InputStream in;

    public BlockingWebSocketHttpServerExchange(HttpServerExchange exchange, Set<WebSocketChannel> peerConnections) {
        super(exchange, peerConnections);
        this.out = exchange.getOutputStream();
        this.in = exchange.getInputStream();
    }

    @Override
    public IoFuture<Void> sendData(ByteBuffer data) {
        try {
            while (data.hasRemaining()) {
                this.out.write(data.get());
            }
            return new FinishedIoFuture<Object>(null);
        }
        catch (IOException e2) {
            FutureResult ioFuture = new FutureResult();
            ioFuture.setException(e2);
            return ioFuture.getIoFuture();
        }
    }

    @Override
    public IoFuture<byte[]> readRequestData() {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        try {
            int r2;
            byte[] buf = new byte[1024];
            while ((r2 = this.in.read(buf)) != -1) {
                data.write(buf, 0, r2);
            }
            return new FinishedIoFuture<byte[]>(data.toByteArray());
        }
        catch (IOException e2) {
            FutureResult ioFuture = new FutureResult();
            ioFuture.setException(e2);
            return ioFuture.getIoFuture();
        }
    }
}

