/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.recipes.cache;

import java.util.Arrays;
import org.apache.curator.utils.PathUtils;
import org.apache.zookeeper.data.Stat;

public class ChildData
implements Comparable<ChildData> {
    private final String path;
    private final Stat stat;
    private final byte[] data;

    public ChildData(String path, Stat stat, byte[] data) {
        this.path = PathUtils.validatePath(path);
        this.stat = stat;
        this.data = data;
    }

    @Override
    public int compareTo(ChildData rhs) {
        if (this == rhs) {
            return 0;
        }
        if (rhs == null || this.getClass() != rhs.getClass()) {
            return -1;
        }
        return this.path.compareTo(rhs.path);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        ChildData childData = (ChildData)o2;
        if (!Arrays.equals(this.data, childData.data)) {
            return false;
        }
        if (this.path != null ? !this.path.equals(childData.path) : childData.path != null) {
            return false;
        }
        return !(this.stat != null ? !this.stat.equals(childData.stat) : childData.stat != null);
    }

    public int hashCode() {
        int result = this.path != null ? this.path.hashCode() : 0;
        result = 31 * result + (this.stat != null ? this.stat.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    public String getPath() {
        return this.path;
    }

    public Stat getStat() {
        return this.stat;
    }

    public byte[] getData() {
        return this.data;
    }

    public String toString() {
        return "ChildData{path='" + this.path + '\'' + ", stat=" + this.stat + ", data=" + Arrays.toString(this.data) + '}';
    }
}

