/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.recipes.queue;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.queue.QueueConsumer;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.shaded.com.google.common.collect.ImmutableList;

public class BlockingQueueConsumer<T>
implements QueueConsumer<T> {
    private final ConnectionStateListener connectionStateListener;
    private final BlockingQueue<T> items;

    public BlockingQueueConsumer(ConnectionStateListener connectionStateListener) {
        this(connectionStateListener, new LinkedBlockingQueue());
    }

    public BlockingQueueConsumer(ConnectionStateListener connectionStateListener, int capacity) {
        this(connectionStateListener, new ArrayBlockingQueue(capacity));
    }

    public BlockingQueueConsumer(ConnectionStateListener connectionStateListener, BlockingQueue<T> queue) {
        this.connectionStateListener = connectionStateListener;
        this.items = queue;
    }

    @Override
    public void consumeMessage(T message) throws Exception {
        this.items.add(message);
    }

    public List<T> getItems() {
        return ImmutableList.copyOf(this.items);
    }

    public int size() {
        return this.items.size();
    }

    public T take() throws InterruptedException {
        return this.items.take();
    }

    public T take(int time, TimeUnit unit) throws InterruptedException {
        return this.items.poll(time, unit);
    }

    public int drainTo(Collection<? super T> c2) {
        return this.items.drainTo(c2);
    }

    @Override
    public void stateChanged(CuratorFramework client, ConnectionState newState) {
        this.connectionStateListener.stateChanged(client, newState);
    }
}

