/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.utils;

public class PathUtils {
    public static void validatePath(String path, boolean isSequential) throws IllegalArgumentException {
        PathUtils.validatePath(isSequential ? path + "1" : path);
    }

    public static String validatePath(String path) throws IllegalArgumentException {
        if (path == null) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException("Path length must be > 0");
        }
        if (path.charAt(0) != '/') {
            throw new IllegalArgumentException("Path must start with / character");
        }
        if (path.length() == 1) {
            return path;
        }
        if (path.charAt(path.length() - 1) == '/') {
            throw new IllegalArgumentException("Path must not end with / character");
        }
        String reason = null;
        int lastc = 47;
        char[] chars = path.toCharArray();
        for (int i2 = 1; i2 < chars.length; ++i2) {
            char c2 = chars[i2];
            if (c2 == '\u0000') {
                reason = "null character not allowed @" + i2;
                break;
            }
            if (c2 == '/' && lastc == 47) {
                reason = "empty node name specified @" + i2;
                break;
            }
            if (c2 == '.' && lastc == 46) {
                if (chars[i2 - 2] == '/' && (i2 + 1 == chars.length || chars[i2 + 1] == '/')) {
                    reason = "relative paths not allowed @" + i2;
                    break;
                }
            } else if (c2 == '.') {
                if (chars[i2 - 1] == '/' && (i2 + 1 == chars.length || chars[i2 + 1] == '/')) {
                    reason = "relative paths not allowed @" + i2;
                    break;
                }
            } else if (c2 > '\u0000' && c2 < '\u001f' || c2 > '\u007f' && c2 < '\u009f' || c2 > '\ud800' && c2 < '\uf8ff' || c2 > '\ufff0' && c2 < '\uffff') {
                reason = "invalid charater @" + i2;
                break;
            }
            lastc = chars[i2];
        }
        if (reason != null) {
            throw new IllegalArgumentException("Invalid path string \"" + path + "\" caused by " + reason);
        }
        return path;
    }
}

