/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.util.copied;

import java.util.Collection;
import org.apache.hc.core5.http.copied.EntityDetails;
import org.apache.hc.core5.util.copied.TextUtils;

public class Args {
    public static void check(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void check(boolean expression, String message, Object ... args) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    public static void check(boolean expression, String message, Object arg) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(message, arg));
        }
    }

    public static long checkContentLength(EntityDetails entityDetails) {
        return Args.checkRange(entityDetails.getContentLength(), -1L, Integer.MAX_VALUE, "HTTP entity too large to be buffered in memory)");
    }

    public static int checkRange(int value, int lowInclusive, int highInclusive, String message) {
        if (value < lowInclusive || value > highInclusive) {
            throw Args.illegalArgumentException("%s: %,d is out of range [%,d, %,d]", message, value, lowInclusive, highInclusive);
        }
        return value;
    }

    public static long checkRange(long value, long lowInclusive, long highInclusive, String message) {
        if (value < lowInclusive || value > highInclusive) {
            throw Args.illegalArgumentException("%s: %,d is out of range [%,d, %,d]", message, value, lowInclusive, highInclusive);
        }
        return value;
    }

    public static <T extends CharSequence> T containsNoBlanks(T argument, String name) {
        if (argument == null) {
            throw Args.illegalArgumentExceptionNotNull(name);
        }
        if (argument.length() == 0) {
            throw Args.illegalArgumentExceptionNotEmpty(name);
        }
        if (TextUtils.containsBlanks(argument)) {
            throw new IllegalArgumentException(name + " must not contain blanks");
        }
        return argument;
    }

    private static IllegalArgumentException illegalArgumentException(String format, Object ... args) {
        return new IllegalArgumentException(String.format(format, args));
    }

    private static IllegalArgumentException illegalArgumentExceptionNotEmpty(String name) {
        return new IllegalArgumentException(name + " must not be empty");
    }

    private static IllegalArgumentException illegalArgumentExceptionNotNull(String name) {
        return new IllegalArgumentException(name + " must not be null");
    }

    public static <T extends CharSequence> T notBlank(T argument, String name) {
        if (argument == null) {
            throw Args.illegalArgumentExceptionNotNull(name);
        }
        if (TextUtils.isBlank(argument)) {
            throw new IllegalArgumentException(name + " must not be blank");
        }
        return argument;
    }

    public static <T extends CharSequence> T notEmpty(T argument, String name) {
        if (argument == null) {
            throw Args.illegalArgumentExceptionNotNull(name);
        }
        if (TextUtils.isEmpty(argument)) {
            throw Args.illegalArgumentExceptionNotEmpty(name);
        }
        return argument;
    }

    public static <E, T extends Collection<E>> T notEmpty(T argument, String name) {
        if (argument == null) {
            throw Args.illegalArgumentExceptionNotNull(name);
        }
        if (argument.isEmpty()) {
            throw Args.illegalArgumentExceptionNotEmpty(name);
        }
        return argument;
    }

    public static int notNegative(int n2, String name) {
        if (n2 < 0) {
            throw Args.illegalArgumentException("%s must not be negative: %,d", name, n2);
        }
        return n2;
    }

    public static long notNegative(long n2, String name) {
        if (n2 < 0L) {
            throw Args.illegalArgumentException("%s must not be negative: %,d", name, n2);
        }
        return n2;
    }

    public static <T> T notNull(T argument, String name) {
        if (argument == null) {
            throw Args.illegalArgumentExceptionNotNull(name);
        }
        return argument;
    }

    public static int positive(int n2, String name) {
        if (n2 <= 0) {
            throw Args.illegalArgumentException("%s must not be negative or zero: %,d", name, n2);
        }
        return n2;
    }

    public static long positive(long n2, String name) {
        if (n2 <= 0L) {
            throw Args.illegalArgumentException("%s must not be negative or zero: %,d", name, n2);
        }
        return n2;
    }

    private Args() {
    }
}

