/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.util.copied;

import java.io.Serializable;
import org.apache.hc.core5.util.copied.Args;
import org.apache.hc.core5.util.copied.CharArrayBuffer;

public final class ByteArrayBuffer
implements Serializable {
    private static final long serialVersionUID = 4359112959524048036L;
    private byte[] array;
    private int len;

    public ByteArrayBuffer(int capacity) {
        Args.notNegative(capacity, "Buffer capacity");
        this.array = new byte[capacity];
    }

    private void expand(int newlen) {
        byte[] newArray = new byte[Math.max(this.array.length << 1, newlen)];
        System.arraycopy(this.array, 0, newArray, 0, this.len);
        this.array = newArray;
    }

    public void append(byte[] b2, int off, int len) {
        if (b2 == null) {
            return;
        }
        if (off < 0 || off > b2.length || len < 0 || off + len < 0 || off + len > b2.length) {
            throw new IndexOutOfBoundsException("off: " + off + " len: " + len + " b.length: " + b2.length);
        }
        if (len == 0) {
            return;
        }
        int newlen = this.len + len;
        if (newlen > this.array.length) {
            this.expand(newlen);
        }
        System.arraycopy(b2, off, this.array, this.len, len);
        this.len = newlen;
    }

    public void append(int b2) {
        int newlen = this.len + 1;
        if (newlen > this.array.length) {
            this.expand(newlen);
        }
        this.array[this.len] = (byte)b2;
        this.len = newlen;
    }

    public void append(char[] b2, int off, int len) {
        if (b2 == null) {
            return;
        }
        if (off < 0 || off > b2.length || len < 0 || off + len < 0 || off + len > b2.length) {
            throw new IndexOutOfBoundsException("off: " + off + " len: " + len + " b.length: " + b2.length);
        }
        if (len == 0) {
            return;
        }
        int oldlen = this.len;
        int newlen = oldlen + len;
        if (newlen > this.array.length) {
            this.expand(newlen);
        }
        int i1 = off;
        for (int i2 = oldlen; i2 < newlen; ++i2) {
            this.array[i2] = (byte)b2[i1];
            ++i1;
        }
        this.len = newlen;
    }

    public void append(CharArrayBuffer b2, int off, int len) {
        if (b2 == null) {
            return;
        }
        this.append(b2.array(), off, len);
    }

    public void clear() {
        this.len = 0;
    }

    public byte[] toByteArray() {
        byte[] b2 = new byte[this.len];
        if (this.len > 0) {
            System.arraycopy(this.array, 0, b2, 0, this.len);
        }
        return b2;
    }

    public int byteAt(int i2) {
        return this.array[i2];
    }

    public int capacity() {
        return this.array.length;
    }

    public int length() {
        return this.len;
    }

    public void ensureCapacity(int required) {
        if (required <= 0) {
            return;
        }
        int available = this.array.length - this.len;
        if (required > available) {
            this.expand(this.len + required);
        }
    }

    public byte[] array() {
        return this.array;
    }

    public void setLength(int len) {
        if (len < 0 || len > this.array.length) {
            throw new IndexOutOfBoundsException("len: " + len + " < 0 or > buffer len: " + this.array.length);
        }
        this.len = len;
    }

    public boolean isEmpty() {
        return this.len == 0;
    }

    public boolean isFull() {
        return this.len == this.array.length;
    }

    public int indexOf(byte b2, int from, int to) {
        int endIndex;
        int beginIndex = from;
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        if ((endIndex = to) > this.len) {
            endIndex = this.len;
        }
        if (beginIndex > endIndex) {
            return -1;
        }
        for (int i2 = beginIndex; i2 < endIndex; ++i2) {
            if (this.array[i2] != b2) continue;
            return i2;
        }
        return -1;
    }

    public int indexOf(byte b2) {
        return this.indexOf(b2, 0, this.len);
    }
}

