/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jute;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.TreeMap;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;

public class BinaryOutputArchive
implements OutputArchive {
    private ByteBuffer bb = ByteBuffer.allocate(1024);
    private DataOutput out;

    public static BinaryOutputArchive getArchive(OutputStream strm) {
        return new BinaryOutputArchive(new DataOutputStream(strm));
    }

    public BinaryOutputArchive(DataOutput out) {
        this.out = out;
    }

    @Override
    public void writeByte(byte b2, String tag) throws IOException {
        this.out.writeByte(b2);
    }

    @Override
    public void writeBool(boolean b2, String tag) throws IOException {
        this.out.writeBoolean(b2);
    }

    @Override
    public void writeInt(int i2, String tag) throws IOException {
        this.out.writeInt(i2);
    }

    @Override
    public void writeLong(long l2, String tag) throws IOException {
        this.out.writeLong(l2);
    }

    @Override
    public void writeFloat(float f2, String tag) throws IOException {
        this.out.writeFloat(f2);
    }

    @Override
    public void writeDouble(double d2, String tag) throws IOException {
        this.out.writeDouble(d2);
    }

    private final ByteBuffer stringToByteBuffer(CharSequence s2) {
        this.bb.clear();
        int len = s2.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c2;
            if (this.bb.remaining() < 3) {
                ByteBuffer n2 = ByteBuffer.allocate(this.bb.capacity() << 1);
                this.bb.flip();
                n2.put(this.bb);
                this.bb = n2;
            }
            if ((c2 = s2.charAt(i2)) < '\u0080') {
                this.bb.put((byte)c2);
                continue;
            }
            if (c2 < '\u0800') {
                this.bb.put((byte)(0xC0 | c2 >> 6));
                this.bb.put((byte)(0x80 | c2 & 0x3F));
                continue;
            }
            this.bb.put((byte)(0xE0 | c2 >> 12));
            this.bb.put((byte)(0x80 | c2 >> 6 & 0x3F));
            this.bb.put((byte)(0x80 | c2 & 0x3F));
        }
        this.bb.flip();
        return this.bb;
    }

    @Override
    public void writeString(String s2, String tag) throws IOException {
        if (s2 == null) {
            this.writeInt(-1, "len");
            return;
        }
        ByteBuffer bb = this.stringToByteBuffer(s2);
        this.writeInt(bb.remaining(), "len");
        this.out.write(bb.array(), bb.position(), bb.limit());
    }

    @Override
    public void writeBuffer(byte[] barr, String tag) throws IOException {
        if (barr == null) {
            this.out.writeInt(-1);
            return;
        }
        this.out.writeInt(barr.length);
        this.out.write(barr);
    }

    @Override
    public void writeRecord(Record r2, String tag) throws IOException {
        r2.serialize(this, tag);
    }

    @Override
    public void startRecord(Record r2, String tag) throws IOException {
    }

    @Override
    public void endRecord(Record r2, String tag) throws IOException {
    }

    @Override
    public void startVector(List<?> v, String tag) throws IOException {
        if (v == null) {
            this.writeInt(-1, tag);
            return;
        }
        this.writeInt(v.size(), tag);
    }

    @Override
    public void endVector(List<?> v, String tag) throws IOException {
    }

    @Override
    public void startMap(TreeMap<?, ?> v, String tag) throws IOException {
        this.writeInt(v.size(), tag);
    }

    @Override
    public void endMap(TreeMap<?, ?> v, String tag) throws IOException {
    }
}

