/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jute.compiler;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.jute.compiler.JFile;
import org.apache.jute.compiler.JRecord;

class CGenerator {
    private String mName;
    private ArrayList<JFile> mInclFiles;
    private ArrayList<JRecord> mRecList;
    private final File outputDirectory;

    CGenerator(String name, ArrayList<JFile> ilist, ArrayList<JRecord> rlist, File outputDirectory) {
        this.outputDirectory = outputDirectory;
        this.mName = new File(name).getName();
        this.mInclFiles = ilist;
        this.mRecList = rlist;
    }

    void genCode() throws IOException {
        if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
            throw new IOException("unable to create output directory " + this.outputDirectory);
        }
        try (FileWriter c2 = new FileWriter(new File(this.outputDirectory, this.mName + ".c"));
             FileWriter h2 = new FileWriter(new File(this.outputDirectory, this.mName + ".h"));){
            h2.write("/**\n");
            h2.write("* Licensed to the Apache Software Foundation (ASF) under one\n");
            h2.write("* or more contributor license agreements.  See the NOTICE file\n");
            h2.write("* distributed with this work for additional information\n");
            h2.write("* regarding copyright ownership.  The ASF licenses this file\n");
            h2.write("* to you under the Apache License, Version 2.0 (the\n");
            h2.write("* \"License\"); you may not use this file except in compliance\n");
            h2.write("* with the License.  You may obtain a copy of the License at\n");
            h2.write("*\n");
            h2.write("*     http://www.apache.org/licenses/LICENSE-2.0\n");
            h2.write("*\n");
            h2.write("* Unless required by applicable law or agreed to in writing, software\n");
            h2.write("* distributed under the License is distributed on an \"AS IS\" BASIS,\n");
            h2.write("* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n");
            h2.write("* See the License for the specific language governing permissions and\n");
            h2.write("* limitations under the License.\n");
            h2.write("*/\n");
            h2.write("\n");
            c2.write("/**\n");
            c2.write("* Licensed to the Apache Software Foundation (ASF) under one\n");
            c2.write("* or more contributor license agreements.  See the NOTICE file\n");
            c2.write("* distributed with this work for additional information\n");
            c2.write("* regarding copyright ownership.  The ASF licenses this file\n");
            c2.write("* to you under the Apache License, Version 2.0 (the\n");
            c2.write("* \"License\"); you may not use this file except in compliance\n");
            c2.write("* with the License.  You may obtain a copy of the License at\n");
            c2.write("*\n");
            c2.write("*     http://www.apache.org/licenses/LICENSE-2.0\n");
            c2.write("*\n");
            c2.write("* Unless required by applicable law or agreed to in writing, software\n");
            c2.write("* distributed under the License is distributed on an \"AS IS\" BASIS,\n");
            c2.write("* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n");
            c2.write("* See the License for the specific language governing permissions and\n");
            c2.write("* limitations under the License.\n");
            c2.write("*/\n");
            c2.write("\n");
            h2.write("#ifndef __" + this.mName.toUpperCase().replace('.', '_') + "__\n");
            h2.write("#define __" + this.mName.toUpperCase().replace('.', '_') + "__\n");
            h2.write("#include \"recordio.h\"\n");
            for (JFile f2 : this.mInclFiles) {
                h2.write("#include \"" + f2.getName() + ".h\"\n");
            }
            h2.write("\n#ifdef __cplusplus\nextern \"C\" {\n#endif\n\n");
            c2.write("#include <stdlib.h>\n");
            c2.write("#include \"" + this.mName + ".h\"\n\n");
            for (JRecord jr : this.mRecList) {
                jr.genCCode(h2, c2);
            }
            h2.write("\n#ifdef __cplusplus\n}\n#endif\n\n");
            h2.write("#endif //" + this.mName.toUpperCase().replace('.', '_') + "__\n");
        }
    }
}

