/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jute.compiler.generated;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.jute.compiler.JBoolean;
import org.apache.jute.compiler.JBuffer;
import org.apache.jute.compiler.JByte;
import org.apache.jute.compiler.JDouble;
import org.apache.jute.compiler.JField;
import org.apache.jute.compiler.JFile;
import org.apache.jute.compiler.JFloat;
import org.apache.jute.compiler.JInt;
import org.apache.jute.compiler.JLong;
import org.apache.jute.compiler.JMap;
import org.apache.jute.compiler.JRecord;
import org.apache.jute.compiler.JString;
import org.apache.jute.compiler.JType;
import org.apache.jute.compiler.JVector;
import org.apache.jute.compiler.generated.ParseException;
import org.apache.jute.compiler.generated.RccConstants;
import org.apache.jute.compiler.generated.RccTokenManager;
import org.apache.jute.compiler.generated.SimpleCharStream;
import org.apache.jute.compiler.generated.Token;

public class Rcc
implements RccConstants {
    private static Hashtable<String, JRecord> recTab = new Hashtable();
    private static String curDir = System.getProperty("user.dir");
    private static String curFileName;
    private static String curModuleName;
    public RccTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[6];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public static void main(String[] args) {
        int i2;
        String language = "java";
        ArrayList<String> recFiles = new ArrayList<String>();
        JFile curFile = null;
        for (i2 = 0; i2 < args.length; ++i2) {
            if ("-l".equalsIgnoreCase(args[i2]) || "--language".equalsIgnoreCase(args[i2])) {
                language = args[i2 + 1].toLowerCase();
                ++i2;
                continue;
            }
            recFiles.add(args[i2]);
        }
        if (!("c++".equals(language) || "java".equals(language) || "c".equals(language))) {
            System.out.println("Cannot recognize language:" + language);
            System.exit(1);
        }
        if (recFiles.size() == 0) {
            System.out.println("No record files specified. Exiting.");
            System.exit(1);
        }
        for (i2 = 0; i2 < recFiles.size(); ++i2) {
            curFileName = (String)recFiles.get(i2);
            File file = new File(curFileName);
            try {
                curFile = Rcc.parseFile(file);
            }
            catch (FileNotFoundException e2) {
                System.out.println("File " + (String)recFiles.get(i2) + " Not found.");
                System.exit(1);
            }
            catch (ParseException e3) {
                System.out.println(e3.toString());
                System.exit(1);
            }
            System.out.println((String)recFiles.get(i2) + " Parsed Successfully");
            try {
                curFile.genCode(language, new File("."));
                continue;
            }
            catch (IOException e4) {
                System.out.println(e4.toString());
                System.exit(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JFile parseFile(File file) throws FileNotFoundException, ParseException {
        curDir = file.getParent();
        curFileName = file.getName();
        FileReader reader = new FileReader(file);
        try {
            Rcc parser = new Rcc(reader);
            recTab = new Hashtable();
            JFile jFile = parser.Input();
            return jFile;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e2) {}
        }
    }

    public final JFile Input() throws ParseException {
        ArrayList<JFile> ilist = new ArrayList<JFile>();
        ArrayList<JRecord> rlist = new ArrayList<JRecord>();
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 13: {
                    JFile i2 = this.Include();
                    ilist.add(i2);
                    break;
                }
                case 11: {
                    ArrayList<JRecord> l2 = this.Module();
                    rlist.addAll(l2);
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 11: 
                case 13: {
                    continue block7;
                }
            }
            break;
        }
        this.jj_la1[1] = this.jj_gen;
        this.jj_consume_token(0);
        return new JFile(curFileName, ilist, rlist);
    }

    public final JFile Include() throws ParseException {
        this.jj_consume_token(13);
        Token t = this.jj_consume_token(31);
        JFile ret = null;
        String fname = t.image.replaceAll("^\"", "").replaceAll("\"$", "");
        File file = new File(curDir, fname);
        String tmpDir = curDir;
        String tmpFile = curFileName;
        curDir = file.getParent();
        curFileName = file.getName();
        try {
            FileReader reader = new FileReader(file);
            Rcc parser = new Rcc(reader);
            try {
                ret = parser.Input();
                System.out.println(fname + " Parsed Successfully");
            }
            catch (ParseException e2) {
                System.out.println(e2.toString());
                System.exit(1);
            }
            try {
                reader.close();
            }
            catch (IOException e3) {}
        }
        catch (FileNotFoundException e4) {
            System.out.println("File " + fname + " Not found.");
            System.exit(1);
        }
        curDir = tmpDir;
        curFileName = tmpFile;
        return ret;
    }

    public final ArrayList<JRecord> Module() throws ParseException {
        String mName;
        this.jj_consume_token(11);
        curModuleName = mName = this.ModuleName();
        this.jj_consume_token(24);
        ArrayList<JRecord> rlist = this.RecordList();
        this.jj_consume_token(25);
        return rlist;
    }

    public final String ModuleName() throws ParseException {
        String name = "";
        Token t = this.jj_consume_token(32);
        name = name + t.image;
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 30: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(30);
            t = this.jj_consume_token(32);
            name = name + "." + t.image;
        }
        return name;
    }

    public final ArrayList<JRecord> RecordList() throws ParseException {
        ArrayList<JRecord> rlist = new ArrayList<JRecord>();
        block3: while (true) {
            JRecord r2 = this.Record();
            rlist.add(r2);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 12: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[3] = this.jj_gen;
        return rlist;
    }

    public final JRecord Record() throws ParseException {
        ArrayList<JField> flist = new ArrayList<JField>();
        this.jj_consume_token(12);
        Token t = this.jj_consume_token(32);
        String rname = t.image;
        this.jj_consume_token(24);
        block3: while (true) {
            JField f2 = this.Field();
            flist.add(f2);
            this.jj_consume_token(28);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 32: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[4] = this.jj_gen;
        this.jj_consume_token(25);
        String fqn = curModuleName + "." + rname;
        JRecord r2 = new JRecord(fqn, flist);
        recTab.put(fqn, r2);
        return r2;
    }

    public final JField Field() throws ParseException {
        JType jt = this.Type();
        Token t = this.jj_consume_token(32);
        return new JField(jt, t.image);
    }

    public final JType Type() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: {
                JMap jt = this.Map();
                return jt;
            }
            case 22: {
                JVector jt = this.Vector();
                return jt;
            }
            case 14: {
                this.jj_consume_token(14);
                return new JByte();
            }
            case 15: {
                this.jj_consume_token(15);
                return new JBoolean();
            }
            case 16: {
                this.jj_consume_token(16);
                return new JInt();
            }
            case 17: {
                this.jj_consume_token(17);
                return new JLong();
            }
            case 18: {
                this.jj_consume_token(18);
                return new JFloat();
            }
            case 19: {
                this.jj_consume_token(19);
                return new JDouble();
            }
            case 20: {
                this.jj_consume_token(20);
                return new JString();
            }
            case 21: {
                this.jj_consume_token(21);
                return new JBuffer();
            }
            case 32: {
                JRecord r2;
                String rname = this.ModuleName();
                if (rname.indexOf(46, 0) < 0) {
                    rname = curModuleName + "." + rname;
                }
                if ((r2 = recTab.get(rname)) == null) {
                    System.out.println("Type " + rname + " not known. Exiting.");
                    System.exit(1);
                }
                return r2;
            }
        }
        this.jj_la1[5] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final JMap Map() throws ParseException {
        this.jj_consume_token(23);
        this.jj_consume_token(26);
        JType jt1 = this.Type();
        this.jj_consume_token(29);
        JType jt2 = this.Type();
        this.jj_consume_token(27);
        return new JMap(jt1, jt2);
    }

    public final JVector Vector() throws ParseException {
        this.jj_consume_token(22);
        this.jj_consume_token(26);
        JType jt = this.Type();
        this.jj_consume_token(27);
        return new JVector(jt);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{10240, 10240, 0x40000000, 4096, 0xFFC000, 0xFFC000};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 1, 1};
    }

    public Rcc(InputStream stream) {
        this(stream, null);
    }

    public Rcc(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException(e2);
        }
        this.token_source = new RccTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i2 = 0; i2 < 6; ++i2) {
            this.jj_la1[i2] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException(e2);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i2 = 0; i2 < 6; ++i2) {
            this.jj_la1[i2] = -1;
        }
    }

    public Rcc(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new RccTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i2 = 0; i2 < 6; ++i2) {
            this.jj_la1[i2] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i2 = 0; i2 < 6; ++i2) {
            this.jj_la1[i2] = -1;
        }
    }

    public Rcc(RccTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i2 = 0; i2 < 6; ++i2) {
            this.jj_la1[i2] = -1;
        }
    }

    public void ReInit(RccTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i2 = 0; i2 < 6; ++i2) {
            this.jj_la1[i2] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i2 = 0; i2 < index; ++i2) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i2;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[33];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i2 = 0; i2 < 6; ++i2) {
            if (this.jj_la1[i2] != this.jj_gen) continue;
            for (int j2 = 0; j2 < 32; ++j2) {
                if ((jj_la1_0[i2] & 1 << j2) != 0) {
                    la1tokens[j2] = true;
                }
                if ((jj_la1_1[i2] & 1 << j2) == 0) continue;
                la1tokens[32 + j2] = true;
            }
        }
        for (i2 = 0; i2 < 33; ++i2) {
            if (!la1tokens[i2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i2;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i3 = 0; i3 < this.jj_expentries.size(); ++i3) {
            exptokseq[i3] = this.jj_expentries.get(i3);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        Rcc.jj_la1_init_0();
        Rcc.jj_la1_init_1();
    }
}

