/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;

public final class Cluster {
    private final boolean isBootstrapConfigured;
    private final List<Node> nodes;
    private final Set<String> unauthorizedTopics;
    private final Set<String> internalTopics;
    private final Node controller;
    private final Map<TopicPartition, PartitionInfo> partitionsByTopicPartition;
    private final Map<String, List<PartitionInfo>> partitionsByTopic;
    private final Map<String, List<PartitionInfo>> availablePartitionsByTopic;
    private final Map<Integer, List<PartitionInfo>> partitionsByNode;
    private final Map<Integer, Node> nodesById;
    private final ClusterResource clusterResource;

    public Cluster(String clusterId, Collection<Node> nodes, Collection<PartitionInfo> partitions, Set<String> unauthorizedTopics, Set<String> internalTopics) {
        this(clusterId, false, nodes, partitions, unauthorizedTopics, internalTopics, null);
    }

    public Cluster(String clusterId, Collection<Node> nodes, Collection<PartitionInfo> partitions, Set<String> unauthorizedTopics, Set<String> internalTopics, Node controller) {
        this(clusterId, false, nodes, partitions, unauthorizedTopics, internalTopics, controller);
    }

    private Cluster(String clusterId, boolean isBootstrapConfigured, Collection<Node> nodes, Collection<PartitionInfo> partitions, Set<String> unauthorizedTopics, Set<String> internalTopics, Node controller) {
        this.isBootstrapConfigured = isBootstrapConfigured;
        this.clusterResource = new ClusterResource(clusterId);
        ArrayList<Node> copy = new ArrayList<Node>(nodes);
        Collections.shuffle(copy);
        this.nodes = Collections.unmodifiableList(copy);
        this.nodesById = new HashMap<Integer, Node>();
        for (Node node : nodes) {
            this.nodesById.put(node.id(), node);
        }
        this.partitionsByTopicPartition = new HashMap<TopicPartition, PartitionInfo>(partitions.size());
        for (PartitionInfo p2 : partitions) {
            this.partitionsByTopicPartition.put(new TopicPartition(p2.topic(), p2.partition()), p2);
        }
        HashMap partsForTopic = new HashMap();
        HashMap partsForNode = new HashMap();
        for (Node node : this.nodes) {
            partsForNode.put(node.id(), new ArrayList());
        }
        for (PartitionInfo partitionInfo : partitions) {
            if (!partsForTopic.containsKey(partitionInfo.topic())) {
                partsForTopic.put(partitionInfo.topic(), new ArrayList());
            }
            List psTopic = (List)partsForTopic.get(partitionInfo.topic());
            psTopic.add(partitionInfo);
            if (partitionInfo.leader() == null) continue;
            List psNode = (List)Utils.notNull(partsForNode.get(partitionInfo.leader().id()));
            psNode.add(partitionInfo);
        }
        this.partitionsByTopic = new HashMap<String, List<PartitionInfo>>(partsForTopic.size());
        this.availablePartitionsByTopic = new HashMap<String, List<PartitionInfo>>(partsForTopic.size());
        for (Map.Entry entry : partsForTopic.entrySet()) {
            String topic = (String)entry.getKey();
            List partitionList = (List)entry.getValue();
            this.partitionsByTopic.put(topic, Collections.unmodifiableList(partitionList));
            ArrayList<PartitionInfo> availablePartitions = new ArrayList<PartitionInfo>();
            for (PartitionInfo part : partitionList) {
                if (part.leader() == null) continue;
                availablePartitions.add(part);
            }
            this.availablePartitionsByTopic.put(topic, Collections.unmodifiableList(availablePartitions));
        }
        this.partitionsByNode = new HashMap<Integer, List<PartitionInfo>>(partsForNode.size());
        for (Map.Entry entry : partsForNode.entrySet()) {
            this.partitionsByNode.put((Integer)entry.getKey(), Collections.unmodifiableList((List)entry.getValue()));
        }
        this.unauthorizedTopics = Collections.unmodifiableSet(unauthorizedTopics);
        this.internalTopics = Collections.unmodifiableSet(internalTopics);
        this.controller = controller;
    }

    public static Cluster empty() {
        return new Cluster(null, new ArrayList<Node>(0), new ArrayList<PartitionInfo>(0), Collections.emptySet(), Collections.emptySet(), null);
    }

    public static Cluster bootstrap(List<InetSocketAddress> addresses) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        int nodeId = -1;
        for (InetSocketAddress address : addresses) {
            nodes.add(new Node(nodeId--, address.getHostString(), address.getPort()));
        }
        return new Cluster(null, true, nodes, new ArrayList<PartitionInfo>(0), Collections.emptySet(), Collections.emptySet(), null);
    }

    public Cluster withPartitions(Map<TopicPartition, PartitionInfo> partitions) {
        HashMap<TopicPartition, PartitionInfo> combinedPartitions = new HashMap<TopicPartition, PartitionInfo>(this.partitionsByTopicPartition);
        combinedPartitions.putAll(partitions);
        return new Cluster(this.clusterResource.clusterId(), this.nodes, combinedPartitions.values(), new HashSet<String>(this.unauthorizedTopics), new HashSet<String>(this.internalTopics), this.controller);
    }

    public List<Node> nodes() {
        return this.nodes;
    }

    public Node nodeById(int id) {
        return this.nodesById.get(id);
    }

    public Node leaderFor(TopicPartition topicPartition) {
        PartitionInfo info = this.partitionsByTopicPartition.get(topicPartition);
        if (info == null) {
            return null;
        }
        return info.leader();
    }

    public PartitionInfo partition(TopicPartition topicPartition) {
        return this.partitionsByTopicPartition.get(topicPartition);
    }

    public List<PartitionInfo> partitionsForTopic(String topic) {
        List<PartitionInfo> parts = this.partitionsByTopic.get(topic);
        return parts == null ? Collections.emptyList() : parts;
    }

    public Integer partitionCountForTopic(String topic) {
        List<PartitionInfo> partitions = this.partitionsByTopic.get(topic);
        return partitions == null ? null : Integer.valueOf(partitions.size());
    }

    public List<PartitionInfo> availablePartitionsForTopic(String topic) {
        List<PartitionInfo> parts = this.availablePartitionsByTopic.get(topic);
        return parts == null ? Collections.emptyList() : parts;
    }

    public List<PartitionInfo> partitionsForNode(int nodeId) {
        List<PartitionInfo> parts = this.partitionsByNode.get(nodeId);
        return parts == null ? Collections.emptyList() : parts;
    }

    public Set<String> topics() {
        return this.partitionsByTopic.keySet();
    }

    public Set<String> unauthorizedTopics() {
        return this.unauthorizedTopics;
    }

    public Set<String> internalTopics() {
        return this.internalTopics;
    }

    public boolean isBootstrapConfigured() {
        return this.isBootstrapConfigured;
    }

    public ClusterResource clusterResource() {
        return this.clusterResource;
    }

    public Node controller() {
        return this.controller;
    }

    public String toString() {
        return "Cluster(id = " + this.clusterResource.clusterId() + ", nodes = " + this.nodes + ", partitions = " + this.partitionsByTopicPartition.values() + ")";
    }
}

