/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.utils.Utils;

public class MetricNameTemplate {
    private final String name;
    private final String group;
    private final String description;
    private Set<String> tags;

    public MetricNameTemplate(String name, String group, String description, Set<String> tags) {
        this.name = Utils.notNull(name);
        this.group = Utils.notNull(group);
        this.description = Utils.notNull(description);
        this.tags = Utils.notNull(tags);
    }

    public MetricNameTemplate(String name, String group, String description, String ... keys) {
        this(name, group, description, MetricNameTemplate.getTags(keys));
    }

    private static Set<String> getTags(String ... keys) {
        HashSet<String> tags = new HashSet<String>();
        for (int i2 = 0; i2 < keys.length; ++i2) {
            tags.add(keys[i2]);
        }
        return tags;
    }

    public String name() {
        return this.name;
    }

    public String group() {
        return this.group;
    }

    public String description() {
        return this.description;
    }

    public Set<String> tags() {
        return this.tags;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.group, this.tags);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        MetricNameTemplate other = (MetricNameTemplate)o2;
        return Objects.equals(this.name, other.name) && Objects.equals(this.group, other.group) && Objects.equals(this.tags, other.tags);
    }

    public String toString() {
        return String.format("name=%s, group=%s, tags=%s", this.name, this.group, this.tags);
    }
}

