/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractConfig {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Set<String> used;
    private final Map<String, ?> originals;
    private final Map<String, Object> values;
    private final ConfigDef definition;

    public AbstractConfig(ConfigDef definition, Map<?, ?> originals, boolean doLog) {
        for (Map.Entry<?, ?> entry : originals.entrySet()) {
            if (entry.getKey() instanceof String) continue;
            throw new ConfigException(entry.getKey().toString(), entry.getValue(), "Key must be a string.");
        }
        this.originals = originals;
        this.values = definition.parse(this.originals);
        Map<String, Object> configUpdates = this.postProcessParsedConfig(Collections.unmodifiableMap(this.values));
        for (Map.Entry<String, Object> update : configUpdates.entrySet()) {
            this.values.put(update.getKey(), update.getValue());
        }
        definition.parse(this.values);
        this.used = Collections.synchronizedSet(new HashSet());
        this.definition = definition;
        if (doLog) {
            this.logAll();
        }
    }

    public AbstractConfig(ConfigDef definition, Map<?, ?> originals) {
        this(definition, originals, true);
    }

    protected Map<String, Object> postProcessParsedConfig(Map<String, Object> parsedValues) {
        return Collections.emptyMap();
    }

    protected Object get(String key) {
        if (!this.values.containsKey(key)) {
            throw new ConfigException(String.format("Unknown configuration '%s'", key));
        }
        this.used.add(key);
        return this.values.get(key);
    }

    public void ignore(String key) {
        this.used.add(key);
    }

    public Short getShort(String key) {
        return (Short)this.get(key);
    }

    public Integer getInt(String key) {
        return (Integer)this.get(key);
    }

    public Long getLong(String key) {
        return (Long)this.get(key);
    }

    public Double getDouble(String key) {
        return (Double)this.get(key);
    }

    public List<String> getList(String key) {
        return (List)this.get(key);
    }

    public Boolean getBoolean(String key) {
        return (Boolean)this.get(key);
    }

    public String getString(String key) {
        return (String)this.get(key);
    }

    public ConfigDef.Type typeOf(String key) {
        ConfigDef.ConfigKey configKey = this.definition.configKeys().get(key);
        if (configKey == null) {
            return null;
        }
        return configKey.type;
    }

    public Password getPassword(String key) {
        return (Password)this.get(key);
    }

    public Class<?> getClass(String key) {
        return (Class)this.get(key);
    }

    public Set<String> unused() {
        HashSet<String> keys = new HashSet<String>(this.originals.keySet());
        keys.removeAll(this.used);
        return keys;
    }

    public Map<String, Object> originals() {
        RecordingMap<Object> copy = new RecordingMap<Object>();
        copy.putAll(this.originals);
        return copy;
    }

    public Map<String, String> originalsStrings() {
        RecordingMap<String> copy = new RecordingMap<String>();
        for (Map.Entry<String, ?> entry : this.originals.entrySet()) {
            if (!(entry.getValue() instanceof String)) {
                throw new ClassCastException("Non-string value found in original settings for key " + entry.getKey() + ": " + (entry.getValue() == null ? null : entry.getValue().getClass().getName()));
            }
            copy.put(entry.getKey(), (String)entry.getValue());
        }
        return copy;
    }

    public Map<String, Object> originalsWithPrefix(String prefix) {
        RecordingMap<Object> result = new RecordingMap<Object>(prefix, false);
        for (Map.Entry<String, ?> entry : this.originals.entrySet()) {
            if (!entry.getKey().startsWith(prefix) || entry.getKey().length() <= prefix.length()) continue;
            result.put(entry.getKey().substring(prefix.length()), entry.getValue());
        }
        return result;
    }

    public Map<String, Object> valuesWithPrefixOverride(String prefix) {
        RecordingMap<Object> result = new RecordingMap<Object>(this.values(), prefix, true);
        for (Map.Entry<String, ?> entry : this.originals.entrySet()) {
            if (!entry.getKey().startsWith(prefix) || entry.getKey().length() <= prefix.length()) continue;
            String keyWithNoPrefix = entry.getKey().substring(prefix.length());
            ConfigDef.ConfigKey configKey = this.definition.configKeys().get(keyWithNoPrefix);
            if (configKey == null) continue;
            result.put(keyWithNoPrefix, this.definition.parseValue(configKey, entry.getValue(), true));
        }
        return result;
    }

    public Map<String, ?> values() {
        return new RecordingMap<Object>(this.values);
    }

    private void logAll() {
        StringBuilder b2 = new StringBuilder();
        b2.append(this.getClass().getSimpleName());
        b2.append(" values: ");
        b2.append(Utils.NL);
        for (Map.Entry<String, Object> entry : new TreeMap<String, Object>(this.values).entrySet()) {
            b2.append('\t');
            b2.append(entry.getKey());
            b2.append(" = ");
            b2.append(entry.getValue());
            b2.append(Utils.NL);
        }
        this.log.info(b2.toString());
    }

    public void logUnused() {
        for (String key : this.unused()) {
            this.log.warn("The configuration '{}' was supplied but isn't a known config.", (Object)key);
        }
    }

    public <T> T getConfiguredInstance(String key, Class<T> t) {
        Class<?> c2 = this.getClass(key);
        if (c2 == null) {
            return null;
        }
        Object o2 = Utils.newInstance(c2);
        if (!t.isInstance(o2)) {
            throw new KafkaException(c2.getName() + " is not an instance of " + t.getName());
        }
        if (o2 instanceof Configurable) {
            ((Configurable)o2).configure(this.originals());
        }
        return t.cast(o2);
    }

    public <T> List<T> getConfiguredInstances(String key, Class<T> t) {
        return this.getConfiguredInstances(key, t, Collections.emptyMap());
    }

    public <T> List<T> getConfiguredInstances(String key, Class<T> t, Map<String, Object> configOverrides) {
        List<String> klasses = this.getList(key);
        ArrayList<T> objects = new ArrayList<T>();
        if (klasses == null) {
            return objects;
        }
        Map<String, Object> configPairs = this.originals();
        configPairs.putAll(configOverrides);
        for (String klass : klasses) {
            T o2;
            if (klass instanceof String) {
                try {
                    o2 = Utils.newInstance(klass, t);
                }
                catch (ClassNotFoundException e2) {
                    throw new KafkaException(klass + " ClassNotFoundException exception occurred", e2);
                }
            } else if (klass instanceof Class) {
                o2 = Utils.newInstance((Class)((Object)klass));
            } else {
                throw new KafkaException("List contains element of type " + klass.getClass().getName() + ", expected String or Class");
            }
            if (!t.isInstance(o2)) {
                throw new KafkaException(klass + " is not an instance of " + t.getName());
            }
            if (o2 instanceof Configurable) {
                ((Configurable)o2).configure(configPairs);
            }
            objects.add(t.cast(o2));
        }
        return objects;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        AbstractConfig that = (AbstractConfig)o2;
        return this.originals.equals(that.originals);
    }

    public int hashCode() {
        return this.originals.hashCode();
    }

    private class RecordingMap<V>
    extends HashMap<String, V> {
        private final String prefix;
        private final boolean withIgnoreFallback;

        RecordingMap() {
            this("", false);
        }

        RecordingMap(String prefix, boolean withIgnoreFallback) {
            this.prefix = prefix;
            this.withIgnoreFallback = withIgnoreFallback;
        }

        RecordingMap(Map<String, ? extends V> m2) {
            this(m2, "", false);
        }

        RecordingMap(Map<String, ? extends V> m2, String prefix, boolean withIgnoreFallback) {
            super(m2);
            this.prefix = prefix;
            this.withIgnoreFallback = withIgnoreFallback;
        }

        @Override
        public V get(Object key) {
            if (key instanceof String) {
                String stringKey = (String)key;
                String keyWithPrefix = this.prefix.isEmpty() ? stringKey : this.prefix + stringKey;
                AbstractConfig.this.ignore(keyWithPrefix);
                if (this.withIgnoreFallback) {
                    AbstractConfig.this.ignore(stringKey);
                }
            }
            return super.get(key);
        }
    }
}

