/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.internals;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;

public class PartitionStates<S> {
    private final LinkedHashMap<TopicPartition, S> map = new LinkedHashMap();

    public void moveToEnd(TopicPartition topicPartition) {
        Object state = this.map.remove(topicPartition);
        if (state != null) {
            this.map.put(topicPartition, state);
        }
    }

    public void updateAndMoveToEnd(TopicPartition topicPartition, S state) {
        this.map.remove(topicPartition);
        this.map.put(topicPartition, state);
    }

    public void remove(TopicPartition topicPartition) {
        this.map.remove(topicPartition);
    }

    public Set<TopicPartition> partitionSet() {
        return new HashSet<TopicPartition>(this.map.keySet());
    }

    public void clear() {
        this.map.clear();
    }

    public boolean contains(TopicPartition topicPartition) {
        return this.map.containsKey(topicPartition);
    }

    public List<PartitionState<S>> partitionStates() {
        ArrayList<PartitionState<S>> result = new ArrayList<PartitionState<S>>();
        for (Map.Entry<TopicPartition, S> entry : this.map.entrySet()) {
            result.add(new PartitionState<S>(entry.getKey(), entry.getValue()));
        }
        return result;
    }

    public List<S> partitionStateValues() {
        return new ArrayList<S>(this.map.values());
    }

    public S stateValue(TopicPartition topicPartition) {
        return this.map.get(topicPartition);
    }

    public int size() {
        return this.map.size();
    }

    public void set(Map<TopicPartition, S> partitionToState) {
        this.map.clear();
        this.update(partitionToState);
    }

    private void update(Map<TopicPartition, S> partitionToState) {
        LinkedHashMap<String, ArrayList<TopicPartition>> topicToPartitions = new LinkedHashMap<String, ArrayList<TopicPartition>>();
        for (TopicPartition topicPartition : partitionToState.keySet()) {
            ArrayList<TopicPartition> partitions = (ArrayList<TopicPartition>)topicToPartitions.get(topicPartition.topic());
            if (partitions == null) {
                partitions = new ArrayList<TopicPartition>();
                topicToPartitions.put(topicPartition.topic(), partitions);
            }
            partitions.add(topicPartition);
        }
        for (Map.Entry entry : topicToPartitions.entrySet()) {
            for (TopicPartition tp : (List)entry.getValue()) {
                S state = partitionToState.get(tp);
                this.map.put(tp, state);
            }
        }
    }

    public static class PartitionState<S> {
        private final TopicPartition topicPartition;
        private final S value;

        public PartitionState(TopicPartition topicPartition, S state) {
            this.topicPartition = Objects.requireNonNull(topicPartition);
            this.value = Objects.requireNonNull(state);
        }

        public S value() {
            return this.value;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            PartitionState that = (PartitionState)o2;
            return this.topicPartition.equals(that.topicPartition) && this.value.equals(that.value);
        }

        public int hashCode() {
            int result = this.topicPartition.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }

        public TopicPartition topicPartition() {
            return this.topicPartition;
        }

        public String toString() {
            return "PartitionState(" + this.topicPartition + "=" + this.value + ')';
        }
    }
}

