/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Map;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.network.Authenticator;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.network.SslTransportLayer;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalBuilder;
import org.apache.kafka.common.security.auth.SslAuthenticationContext;
import org.apache.kafka.common.security.ssl.SslFactory;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslChannelBuilder
implements ChannelBuilder {
    private static final Logger log = LoggerFactory.getLogger(SslChannelBuilder.class);
    private SslFactory sslFactory;
    private Mode mode;
    private Map<String, ?> configs;

    public SslChannelBuilder(Mode mode) {
        this.mode = mode;
    }

    @Override
    public void configure(Map<String, ?> configs) throws KafkaException {
        try {
            this.configs = configs;
            this.sslFactory = new SslFactory(this.mode);
            this.sslFactory.configure(this.configs);
        }
        catch (Exception e2) {
            throw new KafkaException(e2);
        }
    }

    @Override
    public KafkaChannel buildChannel(String id, SelectionKey key, int maxReceiveSize, MemoryPool memoryPool) throws KafkaException {
        try {
            SslTransportLayer transportLayer = this.buildTransportLayer(this.sslFactory, id, key, this.peerHost(key));
            SslAuthenticator authenticator = new SslAuthenticator(this.configs, transportLayer);
            return new KafkaChannel(id, transportLayer, authenticator, maxReceiveSize, memoryPool != null ? memoryPool : MemoryPool.NONE);
        }
        catch (Exception e2) {
            log.info("Failed to create channel due to ", e2);
            throw new KafkaException(e2);
        }
    }

    @Override
    public void close() {
    }

    protected SslTransportLayer buildTransportLayer(SslFactory sslFactory, String id, SelectionKey key, String host) throws IOException {
        SocketChannel socketChannel = (SocketChannel)key.channel();
        return SslTransportLayer.create(id, key, sslFactory.createSslEngine(host, socketChannel.socket().getPort()));
    }

    private String peerHost(SelectionKey key) {
        SocketChannel socketChannel = (SocketChannel)key.channel();
        return new InetSocketAddress(socketChannel.socket().getInetAddress(), 0).getHostString();
    }

    private static class SslAuthenticator
    implements Authenticator {
        private final SslTransportLayer transportLayer;
        private final KafkaPrincipalBuilder principalBuilder;

        private SslAuthenticator(Map<String, ?> configs, SslTransportLayer transportLayer) {
            this.transportLayer = transportLayer;
            this.principalBuilder = ChannelBuilders.createPrincipalBuilder(configs, transportLayer, this, null);
        }

        @Override
        public void authenticate() throws IOException {
        }

        @Override
        public KafkaPrincipal principal() {
            InetAddress clientAddress = this.transportLayer.socketChannel().socket().getInetAddress();
            SslAuthenticationContext context = new SslAuthenticationContext(this.transportLayer.sslSession(), clientAddress);
            return this.principalBuilder.build(context);
        }

        @Override
        public void close() throws IOException {
            if (this.principalBuilder instanceof Closeable) {
                Utils.closeQuietly((Closeable)((Object)this.principalBuilder), "principal builder");
            }
        }

        @Override
        public boolean complete() {
            return true;
        }
    }
}

