/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.BoundField;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.ResponseHeader;

public class Protocol {
    private static String indentString(int size) {
        StringBuilder b2 = new StringBuilder(size);
        for (int i2 = 0; i2 < size; ++i2) {
            b2.append(" ");
        }
        return b2.toString();
    }

    private static void schemaToBnfHtml(Schema schema, StringBuilder b2, int indentSize) {
        String indentStr = Protocol.indentString(indentSize);
        LinkedHashMap<String, Type> subTypes = new LinkedHashMap<String, Type>();
        for (BoundField field : schema.fields()) {
            if (field.def.type instanceof ArrayOf) {
                b2.append("[");
                b2.append(field.def.name);
                b2.append("] ");
                Type innerType = ((ArrayOf)field.def.type).type();
                if (subTypes.containsKey(field.def.name)) continue;
                subTypes.put(field.def.name, innerType);
                continue;
            }
            b2.append(field.def.name);
            b2.append(" ");
            if (subTypes.containsKey(field.def.name)) continue;
            subTypes.put(field.def.name, field.def.type);
        }
        b2.append("\n");
        for (Map.Entry entry : subTypes.entrySet()) {
            if (entry.getValue() instanceof Schema) {
                b2.append(indentStr);
                b2.append((String)entry.getKey());
                b2.append(" => ");
                Protocol.schemaToBnfHtml((Schema)entry.getValue(), b2, indentSize + 2);
                continue;
            }
            b2.append(indentStr);
            b2.append((String)entry.getKey());
            b2.append(" => ");
            b2.append(entry.getValue());
            b2.append("\n");
        }
    }

    private static void populateSchemaFields(Schema schema, Set<BoundField> fields) {
        for (BoundField field : schema.fields()) {
            fields.add(field);
            if (field.def.type instanceof ArrayOf) {
                Type innerType = ((ArrayOf)field.def.type).type();
                if (!(innerType instanceof Schema)) continue;
                Protocol.populateSchemaFields((Schema)innerType, fields);
                continue;
            }
            if (!(field.def.type instanceof Schema)) continue;
            Protocol.populateSchemaFields((Schema)field.def.type, fields);
        }
    }

    private static void schemaToFieldTableHtml(Schema schema, StringBuilder b2) {
        LinkedHashSet<BoundField> fields = new LinkedHashSet<BoundField>();
        Protocol.populateSchemaFields(schema, fields);
        b2.append("<table class=\"data-table\"><tbody>\n");
        b2.append("<tr>");
        b2.append("<th>Field</th>\n");
        b2.append("<th>Description</th>\n");
        b2.append("</tr>");
        for (BoundField field : fields) {
            b2.append("<tr>\n");
            b2.append("<td>");
            b2.append(field.def.name);
            b2.append("</td>");
            b2.append("<td>");
            b2.append(field.def.docString);
            b2.append("</td>");
            b2.append("</tr>\n");
        }
        b2.append("</table>\n");
    }

    public static String toHtml() {
        StringBuilder b2 = new StringBuilder();
        b2.append("<h5>Headers:</h5>\n");
        b2.append("<pre>");
        b2.append("Request Header => ");
        Protocol.schemaToBnfHtml(RequestHeader.SCHEMA, b2, 2);
        b2.append("</pre>\n");
        Protocol.schemaToFieldTableHtml(RequestHeader.SCHEMA, b2);
        b2.append("<pre>");
        b2.append("Response Header => ");
        Protocol.schemaToBnfHtml(ResponseHeader.SCHEMA, b2, 2);
        b2.append("</pre>\n");
        Protocol.schemaToFieldTableHtml(ResponseHeader.SCHEMA, b2);
        for (ApiKeys key : ApiKeys.values()) {
            b2.append("<h5>");
            b2.append("<a name=\"The_Messages_" + key.name + "\">");
            b2.append(key.name);
            b2.append(" API (Key: ");
            b2.append(key.id);
            b2.append("):</a></h5>\n\n");
            b2.append("<b>Requests:</b><br>\n");
            Schema[] requests = key.requestSchemas;
            for (int i2 = 0; i2 < requests.length; ++i2) {
                Schema schema = requests[i2];
                if (schema != null) {
                    b2.append("<p>");
                    b2.append("<pre>");
                    b2.append(key.name);
                    b2.append(" Request (Version: ");
                    b2.append(i2);
                    b2.append(") => ");
                    Protocol.schemaToBnfHtml(requests[i2], b2, 2);
                    b2.append("</pre>");
                    Protocol.schemaToFieldTableHtml(requests[i2], b2);
                }
                b2.append("</p>\n");
            }
            b2.append("<b>Responses:</b><br>\n");
            Schema[] responses = key.responseSchemas;
            for (int i3 = 0; i3 < responses.length; ++i3) {
                Schema schema = responses[i3];
                if (schema != null) {
                    b2.append("<p>");
                    b2.append("<pre>");
                    b2.append(key.name);
                    b2.append(" Response (Version: ");
                    b2.append(i3);
                    b2.append(") => ");
                    Protocol.schemaToBnfHtml(responses[i3], b2, 2);
                    b2.append("</pre>");
                    Protocol.schemaToFieldTableHtml(responses[i3], b2);
                }
                b2.append("</p>\n");
            }
        }
        return b2.toString();
    }

    public static void main(String[] args) {
        System.out.println(Protocol.toHtml());
    }
}

