/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.record.AbstractLegacyRecordBatch;
import org.apache.kafka.common.record.AbstractRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.DefaultRecord;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.ByteBufferOutputStream;
import org.apache.kafka.common.utils.Utils;

public class MemoryRecordsBuilder {
    private static final float COMPRESSION_RATE_ESTIMATION_FACTOR = 1.05f;
    private final TimestampType timestampType;
    private final CompressionType compressionType;
    private final DataOutputStream appendStream;
    private final ByteBufferOutputStream bufferStream;
    private final byte magic;
    private final int initialPosition;
    private final long baseOffset;
    private final long logAppendTime;
    private final boolean isControlBatch;
    private final int partitionLeaderEpoch;
    private final int writeLimit;
    private final int batchHeaderSizeInBytes;
    private float estimatedCompressionRatio = 1.0f;
    private boolean appendStreamIsClosed = false;
    private boolean isTransactional;
    private long producerId;
    private short producerEpoch;
    private int baseSequence;
    private int uncompressedRecordsSizeInBytes = 0;
    private int numRecords = 0;
    private float actualCompressionRatio = 1.0f;
    private long maxTimestamp = -1L;
    private long offsetOfMaxTimestamp = -1L;
    private Long lastOffset = null;
    private Long firstTimestamp = null;
    private MemoryRecords builtRecords;
    private boolean aborted = false;

    public MemoryRecordsBuilder(ByteBufferOutputStream bufferStream, byte magic, CompressionType compressionType, TimestampType timestampType, long baseOffset, long logAppendTime, long producerId, short producerEpoch, int baseSequence, boolean isTransactional, boolean isControlBatch, int partitionLeaderEpoch, int writeLimit) {
        if (magic > 0 && timestampType == TimestampType.NO_TIMESTAMP_TYPE) {
            throw new IllegalArgumentException("TimestampType must be set for magic >= 0");
        }
        if (magic < 2) {
            if (isTransactional) {
                throw new IllegalArgumentException("Transactional records are not supported for magic " + magic);
            }
            if (isControlBatch) {
                throw new IllegalArgumentException("Control records are not supported for magic " + magic);
            }
        }
        this.magic = magic;
        this.timestampType = timestampType;
        this.compressionType = compressionType;
        this.baseOffset = baseOffset;
        this.logAppendTime = logAppendTime;
        this.numRecords = 0;
        this.uncompressedRecordsSizeInBytes = 0;
        this.actualCompressionRatio = 1.0f;
        this.maxTimestamp = -1L;
        this.producerId = producerId;
        this.producerEpoch = producerEpoch;
        this.baseSequence = baseSequence;
        this.isTransactional = isTransactional;
        this.isControlBatch = isControlBatch;
        this.partitionLeaderEpoch = partitionLeaderEpoch;
        this.writeLimit = writeLimit;
        this.initialPosition = bufferStream.position();
        this.batchHeaderSizeInBytes = AbstractRecords.recordBatchHeaderSizeInBytes(magic, compressionType);
        bufferStream.position(this.initialPosition + this.batchHeaderSizeInBytes);
        this.bufferStream = bufferStream;
        this.appendStream = new DataOutputStream(compressionType.wrapForOutput(this.bufferStream, magic));
    }

    public MemoryRecordsBuilder(ByteBuffer buffer, byte magic, CompressionType compressionType, TimestampType timestampType, long baseOffset, long logAppendTime, long producerId, short producerEpoch, int baseSequence, boolean isTransactional, boolean isControlBatch, int partitionLeaderEpoch, int writeLimit) {
        this(new ByteBufferOutputStream(buffer), magic, compressionType, timestampType, baseOffset, logAppendTime, producerId, producerEpoch, baseSequence, isTransactional, isControlBatch, partitionLeaderEpoch, writeLimit);
    }

    public ByteBuffer buffer() {
        return this.bufferStream.buffer();
    }

    public int initialCapacity() {
        return this.bufferStream.initialCapacity();
    }

    public double compressionRatio() {
        return this.actualCompressionRatio;
    }

    public CompressionType compressionType() {
        return this.compressionType;
    }

    public boolean isControlBatch() {
        return this.isControlBatch;
    }

    public boolean isTransactional() {
        return this.isTransactional;
    }

    public MemoryRecords build() {
        if (this.aborted) {
            throw new IllegalStateException("Attempting to build an aborted record batch");
        }
        this.close();
        return this.builtRecords;
    }

    public RecordsInfo info() {
        if (this.timestampType == TimestampType.LOG_APPEND_TIME) {
            long shallowOffsetOfMaxTimestamp = this.compressionType != CompressionType.NONE || this.magic >= 2 ? this.lastOffset : this.baseOffset;
            return new RecordsInfo(this.logAppendTime, shallowOffsetOfMaxTimestamp);
        }
        if (this.maxTimestamp == -1L) {
            return new RecordsInfo(-1L, this.lastOffset);
        }
        long shallowOffsetOfMaxTimestamp = this.compressionType != CompressionType.NONE || this.magic >= 2 ? this.lastOffset : this.offsetOfMaxTimestamp;
        return new RecordsInfo(this.maxTimestamp, shallowOffsetOfMaxTimestamp);
    }

    public int numRecords() {
        return this.numRecords;
    }

    public int uncompressedBytesWritten() {
        return this.uncompressedRecordsSizeInBytes + this.batchHeaderSizeInBytes;
    }

    public void setProducerState(long producerId, short producerEpoch, int baseSequence, boolean isTransactional) {
        if (this.isClosed()) {
            throw new IllegalStateException("Trying to set producer state of an already closed batch. This indicates a bug on the client.");
        }
        this.producerId = producerId;
        this.producerEpoch = producerEpoch;
        this.baseSequence = baseSequence;
        this.isTransactional = isTransactional;
    }

    public void overrideLastOffset(long lastOffset) {
        if (this.builtRecords != null) {
            throw new IllegalStateException("Cannot override the last offset after the records have been built");
        }
        this.lastOffset = lastOffset;
    }

    public void closeForRecordAppends() {
        if (!this.appendStreamIsClosed) {
            try {
                this.appendStream.close();
                this.appendStreamIsClosed = true;
            }
            catch (IOException e2) {
                throw new KafkaException(e2);
            }
        }
    }

    public void abort() {
        this.closeForRecordAppends();
        this.buffer().position(this.initialPosition);
        this.aborted = true;
    }

    public void reopenAndRewriteProducerState(long producerId, short producerEpoch, int baseSequence, boolean isTransactional) {
        if (this.aborted) {
            throw new IllegalStateException("Should not reopen a batch which is already aborted.");
        }
        this.builtRecords = null;
        this.producerId = producerId;
        this.producerEpoch = producerEpoch;
        this.baseSequence = baseSequence;
        this.isTransactional = isTransactional;
    }

    public void close() {
        if (this.aborted) {
            throw new IllegalStateException("Cannot close MemoryRecordsBuilder as it has already been aborted");
        }
        if (this.builtRecords != null) {
            return;
        }
        this.validateProducerState();
        this.closeForRecordAppends();
        if ((long)this.numRecords == 0L) {
            this.buffer().position(this.initialPosition);
            this.builtRecords = MemoryRecords.EMPTY;
        } else {
            if (this.magic > 1) {
                this.actualCompressionRatio = (float)this.writeDefaultBatchHeader() / (float)this.uncompressedRecordsSizeInBytes;
            } else if (this.compressionType != CompressionType.NONE) {
                this.actualCompressionRatio = (float)this.writeLegacyCompressedWrapperHeader() / (float)this.uncompressedRecordsSizeInBytes;
            }
            ByteBuffer buffer = this.buffer().duplicate();
            buffer.flip();
            buffer.position(this.initialPosition);
            this.builtRecords = MemoryRecords.readableRecords(buffer.slice());
        }
    }

    private void validateProducerState() {
        if (this.isTransactional && this.producerId == -1L) {
            throw new IllegalArgumentException("Cannot write transactional messages without a valid producer ID");
        }
        if (this.producerId != -1L) {
            if (this.producerEpoch == -1) {
                throw new IllegalArgumentException("Invalid negative producer epoch");
            }
            if (this.baseSequence < 0 && !this.isControlBatch) {
                throw new IllegalArgumentException("Invalid negative sequence number used");
            }
            if (this.magic < 2) {
                throw new IllegalArgumentException("Idempotent messages are not supported for magic " + this.magic);
            }
        }
    }

    private int writeDefaultBatchHeader() {
        this.ensureOpenForRecordBatchWrite();
        ByteBuffer buffer = this.bufferStream.buffer();
        int pos = buffer.position();
        buffer.position(this.initialPosition);
        int size = pos - this.initialPosition;
        int writtenCompressed = size - 61;
        int offsetDelta = (int)(this.lastOffset - this.baseOffset);
        long maxTimestamp = this.timestampType == TimestampType.LOG_APPEND_TIME ? this.logAppendTime : this.maxTimestamp;
        DefaultRecordBatch.writeHeader(buffer, this.baseOffset, offsetDelta, size, this.magic, this.compressionType, this.timestampType, this.firstTimestamp, maxTimestamp, this.producerId, this.producerEpoch, this.baseSequence, this.isTransactional, this.isControlBatch, this.partitionLeaderEpoch, this.numRecords);
        buffer.position(pos);
        return writtenCompressed;
    }

    private int writeLegacyCompressedWrapperHeader() {
        this.ensureOpenForRecordBatchWrite();
        ByteBuffer buffer = this.bufferStream.buffer();
        int pos = buffer.position();
        buffer.position(this.initialPosition);
        int wrapperSize = pos - this.initialPosition - 12;
        int writtenCompressed = wrapperSize - LegacyRecord.recordOverhead(this.magic);
        AbstractLegacyRecordBatch.writeHeader(buffer, (long)this.lastOffset, wrapperSize);
        long timestamp = this.timestampType == TimestampType.LOG_APPEND_TIME ? this.logAppendTime : this.maxTimestamp;
        LegacyRecord.writeCompressedRecordHeader(buffer, this.magic, wrapperSize, timestamp, this.compressionType, this.timestampType);
        buffer.position(pos);
        return writtenCompressed;
    }

    private Long appendWithOffset(long offset, boolean isControlRecord, long timestamp, ByteBuffer key, ByteBuffer value, Header[] headers) {
        try {
            if (isControlRecord != this.isControlBatch) {
                throw new IllegalArgumentException("Control records can only be appended to control batches");
            }
            if (this.lastOffset != null && offset <= this.lastOffset) {
                throw new IllegalArgumentException(String.format("Illegal offset %s following previous offset %s (Offsets must increase monotonically).", offset, this.lastOffset));
            }
            if (timestamp < 0L && timestamp != -1L) {
                throw new IllegalArgumentException("Invalid negative timestamp " + timestamp);
            }
            if (this.magic < 2 && headers != null && headers.length > 0) {
                throw new IllegalArgumentException("Magic v" + this.magic + " does not support record headers");
            }
            if (this.firstTimestamp == null) {
                this.firstTimestamp = timestamp;
            }
            if (this.magic > 1) {
                this.appendDefaultRecord(offset, timestamp, key, value, headers);
                return null;
            }
            return this.appendLegacyRecord(offset, timestamp, key, value);
        }
        catch (IOException e2) {
            throw new KafkaException("I/O exception when writing to the append stream, closing", e2);
        }
    }

    public Long appendWithOffset(long offset, long timestamp, byte[] key, byte[] value, Header[] headers) {
        return this.appendWithOffset(offset, false, timestamp, Utils.wrapNullable(key), Utils.wrapNullable(value), headers);
    }

    public Long appendWithOffset(long offset, long timestamp, ByteBuffer key, ByteBuffer value, Header[] headers) {
        return this.appendWithOffset(offset, false, timestamp, key, value, headers);
    }

    public Long appendWithOffset(long offset, long timestamp, byte[] key, byte[] value) {
        return this.appendWithOffset(offset, timestamp, Utils.wrapNullable(key), Utils.wrapNullable(value), Record.EMPTY_HEADERS);
    }

    public Long appendWithOffset(long offset, long timestamp, ByteBuffer key, ByteBuffer value) {
        return this.appendWithOffset(offset, timestamp, key, value, Record.EMPTY_HEADERS);
    }

    public Long appendWithOffset(long offset, SimpleRecord record) {
        return this.appendWithOffset(offset, record.timestamp(), record.key(), record.value(), record.headers());
    }

    public Long append(long timestamp, ByteBuffer key, ByteBuffer value) {
        return this.append(timestamp, key, value, Record.EMPTY_HEADERS);
    }

    public Long append(long timestamp, ByteBuffer key, ByteBuffer value, Header[] headers) {
        return this.appendWithOffset(this.nextSequentialOffset(), timestamp, key, value, headers);
    }

    public Long append(long timestamp, byte[] key, byte[] value) {
        return this.append(timestamp, Utils.wrapNullable(key), Utils.wrapNullable(value), Record.EMPTY_HEADERS);
    }

    public Long append(long timestamp, byte[] key, byte[] value, Header[] headers) {
        return this.append(timestamp, Utils.wrapNullable(key), Utils.wrapNullable(value), headers);
    }

    public Long append(SimpleRecord record) {
        return this.appendWithOffset(this.nextSequentialOffset(), record);
    }

    private Long appendControlRecord(long timestamp, ControlRecordType type, ByteBuffer value) {
        Struct keyStruct = type.recordKey();
        ByteBuffer key = ByteBuffer.allocate(keyStruct.sizeOf());
        keyStruct.writeTo(key);
        key.flip();
        return this.appendWithOffset(this.nextSequentialOffset(), true, timestamp, key, value, Record.EMPTY_HEADERS);
    }

    public Long appendEndTxnMarker(long timestamp, EndTransactionMarker marker) {
        if (this.producerId == -1L) {
            throw new IllegalArgumentException("End transaction marker requires a valid producerId");
        }
        if (!this.isTransactional) {
            throw new IllegalArgumentException("End transaction marker depends on batch transactional flag being enabled");
        }
        ByteBuffer value = marker.serializeValue();
        return this.appendControlRecord(timestamp, marker.controlType(), value);
    }

    public void appendUncheckedWithOffset(long offset, LegacyRecord record) {
        this.ensureOpenForRecordAppend();
        try {
            int size = record.sizeInBytes();
            AbstractLegacyRecordBatch.writeHeader(this.appendStream, this.toInnerOffset(offset), size);
            ByteBuffer buffer = record.buffer().duplicate();
            this.appendStream.write(buffer.array(), buffer.arrayOffset(), buffer.limit());
            this.recordWritten(offset, record.timestamp(), size + 12);
        }
        catch (IOException e2) {
            throw new KafkaException("I/O exception when writing to the append stream, closing", e2);
        }
    }

    public void append(Record record) {
        this.appendWithOffset(record.offset(), this.isControlBatch, record.timestamp(), record.key(), record.value(), record.headers());
    }

    public void appendWithOffset(long offset, Record record) {
        this.appendWithOffset(offset, record.timestamp(), record.key(), record.value(), record.headers());
    }

    public void appendWithOffset(long offset, LegacyRecord record) {
        this.appendWithOffset(offset, record.timestamp(), record.key(), record.value());
    }

    public void append(LegacyRecord record) {
        this.appendWithOffset(this.nextSequentialOffset(), record);
    }

    private void appendDefaultRecord(long offset, long timestamp, ByteBuffer key, ByteBuffer value, Header[] headers) throws IOException {
        this.ensureOpenForRecordAppend();
        int offsetDelta = (int)(offset - this.baseOffset);
        long timestampDelta = timestamp - this.firstTimestamp;
        int sizeInBytes = DefaultRecord.writeTo(this.appendStream, offsetDelta, timestampDelta, key, value, headers);
        this.recordWritten(offset, timestamp, sizeInBytes);
    }

    private long appendLegacyRecord(long offset, long timestamp, ByteBuffer key, ByteBuffer value) throws IOException {
        this.ensureOpenForRecordAppend();
        if (this.compressionType == CompressionType.NONE && this.timestampType == TimestampType.LOG_APPEND_TIME) {
            timestamp = this.logAppendTime;
        }
        int size = LegacyRecord.recordSize(this.magic, key, value);
        AbstractLegacyRecordBatch.writeHeader(this.appendStream, this.toInnerOffset(offset), size);
        if (this.timestampType == TimestampType.LOG_APPEND_TIME) {
            timestamp = this.logAppendTime;
        }
        long crc = LegacyRecord.write(this.appendStream, this.magic, timestamp, key, value, CompressionType.NONE, this.timestampType);
        this.recordWritten(offset, timestamp, size + 12);
        return crc;
    }

    private long toInnerOffset(long offset) {
        if (this.magic > 0 && this.compressionType != CompressionType.NONE) {
            return offset - this.baseOffset;
        }
        return offset;
    }

    private void recordWritten(long offset, long timestamp, int size) {
        if (this.numRecords == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Maximum number of records per batch exceeded, max records: 2147483647");
        }
        if (offset - this.baseOffset > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Maximum offset delta exceeded, base offset: " + this.baseOffset + ", last offset: " + offset);
        }
        ++this.numRecords;
        this.uncompressedRecordsSizeInBytes += size;
        this.lastOffset = offset;
        if (this.magic > 0 && timestamp > this.maxTimestamp) {
            this.maxTimestamp = timestamp;
            this.offsetOfMaxTimestamp = offset;
        }
    }

    private void ensureOpenForRecordAppend() {
        if (this.appendStreamIsClosed) {
            throw new IllegalStateException("Tried to append a record, but MemoryRecordsBuilder is closed for record appends");
        }
    }

    private void ensureOpenForRecordBatchWrite() {
        if (this.isClosed()) {
            throw new IllegalStateException("Tried to write record batch header, but MemoryRecordsBuilder is closed");
        }
        if (this.aborted) {
            throw new IllegalStateException("Tried to write record batch header, but MemoryRecordsBuilder is aborted");
        }
    }

    private int estimatedBytesWritten() {
        if (this.compressionType == CompressionType.NONE) {
            return this.batchHeaderSizeInBytes + this.uncompressedRecordsSizeInBytes;
        }
        return this.batchHeaderSizeInBytes + (int)((float)this.uncompressedRecordsSizeInBytes * this.estimatedCompressionRatio * 1.05f);
    }

    public void setEstimatedCompressionRatio(float estimatedCompressionRatio) {
        this.estimatedCompressionRatio = estimatedCompressionRatio;
    }

    public boolean hasRoomFor(long timestamp, byte[] key, byte[] value, Header[] headers) {
        return this.hasRoomFor(timestamp, Utils.wrapNullable(key), Utils.wrapNullable(value), headers);
    }

    public boolean hasRoomFor(long timestamp, ByteBuffer key, ByteBuffer value, Header[] headers) {
        int recordSize;
        if (this.isFull()) {
            return false;
        }
        if (this.numRecords == 0) {
            return true;
        }
        if (this.magic < 2) {
            recordSize = 12 + LegacyRecord.recordSize(this.magic, key, value);
        } else {
            int nextOffsetDelta = this.lastOffset == null ? 0 : (int)(this.lastOffset - this.baseOffset + 1L);
            long timestampDelta = this.firstTimestamp == null ? 0L : timestamp - this.firstTimestamp;
            recordSize = DefaultRecord.sizeInBytes(nextOffsetDelta, timestampDelta, key, value, headers);
        }
        return this.writeLimit >= this.estimatedBytesWritten() + recordSize;
    }

    public boolean isClosed() {
        return this.builtRecords != null;
    }

    public boolean isFull() {
        return this.appendStreamIsClosed || this.numRecords > 0 && this.writeLimit <= this.estimatedBytesWritten();
    }

    public int estimatedSizeInBytes() {
        return this.builtRecords != null ? this.builtRecords.sizeInBytes() : this.estimatedBytesWritten();
    }

    public byte magic() {
        return this.magic;
    }

    private long nextSequentialOffset() {
        return this.lastOffset == null ? this.baseOffset : this.lastOffset + 1L;
    }

    public long producerId() {
        return this.producerId;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public int baseSequence() {
        return this.baseSequence;
    }

    public static class RecordsInfo {
        public final long maxTimestamp;
        public final long shallowOffsetOfMaxTimestamp;

        public RecordsInfo(long maxTimestamp, long shallowOffsetOfMaxTimestamp) {
            this.maxTimestamp = maxTimestamp;
            this.shallowOffsetOfMaxTimestamp = shallowOffsetOfMaxTimestamp;
        }
    }
}

