/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterConfigsResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.Resource;
import org.apache.kafka.common.requests.ResourceType;

public class AlterConfigsRequest
extends AbstractRequest {
    private static final String RESOURCES_KEY_NAME = "resources";
    private static final String RESOURCE_TYPE_KEY_NAME = "resource_type";
    private static final String RESOURCE_NAME_KEY_NAME = "resource_name";
    private static final String VALIDATE_ONLY_KEY_NAME = "validate_only";
    private static final String CONFIG_ENTRIES_KEY_NAME = "config_entries";
    private static final String CONFIG_NAME = "config_name";
    private static final String CONFIG_VALUE = "config_value";
    private static final Schema CONFIG_ENTRY = new Schema(new Field("config_name", Type.STRING, "Configuration name"), new Field("config_value", Type.NULLABLE_STRING, "Configuration value"));
    private static final Schema ALTER_CONFIGS_REQUEST_RESOURCE_V0 = new Schema(new Field("resource_type", Type.INT8), new Field("resource_name", Type.STRING), new Field("config_entries", new ArrayOf(CONFIG_ENTRY)));
    private static final Schema ALTER_CONFIGS_REQUEST_V0 = new Schema(new Field("resources", new ArrayOf(ALTER_CONFIGS_REQUEST_RESOURCE_V0), "An array of resources to update with the provided configs."), new Field("validate_only", Type.BOOLEAN));
    private final Map<Resource, Config> configs;
    private final boolean validateOnly;

    public static Schema[] schemaVersions() {
        return new Schema[]{ALTER_CONFIGS_REQUEST_V0};
    }

    public AlterConfigsRequest(short version, Map<Resource, Config> configs, boolean validateOnly) {
        super(version);
        this.configs = configs;
        this.validateOnly = validateOnly;
    }

    public AlterConfigsRequest(Struct struct, short version) {
        super(version);
        this.validateOnly = struct.getBoolean(VALIDATE_ONLY_KEY_NAME);
        Object[] resourcesArray = struct.getArray(RESOURCES_KEY_NAME);
        this.configs = new HashMap<Resource, Config>(resourcesArray.length);
        for (Object resourcesObj : resourcesArray) {
            Struct resourcesStruct = (Struct)resourcesObj;
            ResourceType resourceType = ResourceType.forId(resourcesStruct.getByte(RESOURCE_TYPE_KEY_NAME));
            String resourceName = resourcesStruct.getString(RESOURCE_NAME_KEY_NAME);
            Resource resource = new Resource(resourceType, resourceName);
            Object[] configEntriesArray = resourcesStruct.getArray(CONFIG_ENTRIES_KEY_NAME);
            ArrayList<ConfigEntry> configEntries = new ArrayList<ConfigEntry>(configEntriesArray.length);
            for (Object configEntriesObj : configEntriesArray) {
                Struct configEntriesStruct = (Struct)configEntriesObj;
                String configName = configEntriesStruct.getString(CONFIG_NAME);
                String configValue = configEntriesStruct.getString(CONFIG_VALUE);
                configEntries.add(new ConfigEntry(configName, configValue));
            }
            Config config = new Config(configEntries);
            this.configs.put(resource, config);
        }
    }

    public Map<Resource, Config> configs() {
        return this.configs;
    }

    public boolean validateOnly() {
        return this.validateOnly;
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.ALTER_CONFIGS.requestSchema(this.version()));
        struct.set(VALIDATE_ONLY_KEY_NAME, (Object)this.validateOnly);
        ArrayList<Struct> resourceStructs = new ArrayList<Struct>(this.configs.size());
        for (Map.Entry<Resource, Config> entry : this.configs.entrySet()) {
            Struct resourceStruct = struct.instance(RESOURCES_KEY_NAME);
            Resource resource = entry.getKey();
            resourceStruct.set(RESOURCE_TYPE_KEY_NAME, (Object)resource.type().id());
            resourceStruct.set(RESOURCE_NAME_KEY_NAME, (Object)resource.name());
            Config config = entry.getValue();
            ArrayList<Struct> configEntryStructs = new ArrayList<Struct>(config.entries.size());
            for (ConfigEntry configEntry : config.entries) {
                Struct configEntriesStruct = resourceStruct.instance(CONFIG_ENTRIES_KEY_NAME);
                configEntriesStruct.set(CONFIG_NAME, (Object)configEntry.name);
                configEntriesStruct.set(CONFIG_VALUE, (Object)configEntry.value);
                configEntryStructs.add(configEntriesStruct);
            }
            resourceStruct.set(CONFIG_ENTRIES_KEY_NAME, (Object)configEntryStructs.toArray(new Struct[0]));
            resourceStructs.add(resourceStruct);
        }
        struct.set(RESOURCES_KEY_NAME, (Object)resourceStructs.toArray(new Struct[0]));
        return struct;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e2) {
        short version = this.version();
        switch (version) {
            case 0: {
                ApiError error = ApiError.fromThrowable(e2);
                HashMap<Resource, ApiError> errors = new HashMap<Resource, ApiError>(this.configs.size());
                for (Resource resource : this.configs.keySet()) {
                    errors.put(resource, error);
                }
                return new AlterConfigsResponse(throttleTimeMs, errors);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", version, this.getClass().getSimpleName(), ApiKeys.ALTER_CONFIGS.latestVersion()));
    }

    public static AlterConfigsRequest parse(ByteBuffer buffer, short version) {
        return new AlterConfigsRequest(ApiKeys.ALTER_CONFIGS.parseRequest(version, buffer), version);
    }

    public static class Builder
    extends AbstractRequest.Builder {
        private final Map<Resource, Config> configs;
        private final boolean validateOnly;

        public Builder(Map<Resource, Config> configs, boolean validateOnly) {
            super(ApiKeys.ALTER_CONFIGS);
            this.configs = configs;
            this.validateOnly = validateOnly;
        }

        public AlterConfigsRequest build(short version) {
            return new AlterConfigsRequest(version, this.configs, this.validateOnly);
        }
    }

    public static class ConfigEntry {
        private final String name;
        private final String value;

        public ConfigEntry(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }
    }

    public static class Config {
        private final Collection<ConfigEntry> entries;

        public Config(Collection<ConfigEntry> entries) {
            this.entries = entries;
        }

        public Collection<ConfigEntry> entries() {
            return this.entries;
        }
    }
}

