/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreatePartitionsResponse;

public class CreatePartitionsRequest
extends AbstractRequest {
    private static final String TOPIC_PARTITIONS_KEY_NAME = "topic_partitions";
    private static final String NEW_PARTITIONS_KEY_NAME = "new_partitions";
    private static final String COUNT_KEY_NAME = "count";
    private static final String ASSIGNMENT_KEY_NAME = "assignment";
    private static final String TIMEOUT_KEY_NAME = "timeout";
    private static final String VALIDATE_ONLY_KEY_NAME = "validate_only";
    private static final Schema CREATE_PARTITIONS_REQUEST_V0 = new Schema(new Field("topic_partitions", new ArrayOf(new Schema(CommonFields.TOPIC_NAME, new Field("new_partitions", new Schema(new Field("count", Type.INT32, "The new partition count."), new Field("assignment", ArrayOf.nullable(new ArrayOf(Type.INT32)), "The assigned brokers."))))), "List of topic and the corresponding new partitions."), new Field("timeout", Type.INT32, "The time in ms to wait for the partitions to be created."), new Field("validate_only", Type.BOOLEAN, "If true then validate the request, but don't actually increase the number of partitions."));
    private final Set<String> duplicates;
    private final Map<String, NewPartitions> newPartitions;
    private final int timeout;
    private final boolean validateOnly;

    public static Schema[] schemaVersions() {
        return new Schema[]{CREATE_PARTITIONS_REQUEST_V0};
    }

    CreatePartitionsRequest(Map<String, NewPartitions> newPartitions, int timeout, boolean validateOnly, short apiVersion) {
        super(apiVersion);
        this.newPartitions = newPartitions;
        this.duplicates = Collections.emptySet();
        this.timeout = timeout;
        this.validateOnly = validateOnly;
    }

    public CreatePartitionsRequest(Struct struct, short apiVersion) {
        super(apiVersion);
        Object[] topicCountArray = struct.getArray(TOPIC_PARTITIONS_KEY_NAME);
        HashMap<String, NewPartitions> counts = new HashMap<String, NewPartitions>(topicCountArray.length);
        HashSet<String> dupes = new HashSet<String>();
        for (Object topicPartitionCountObj : topicCountArray) {
            NewPartitions newPartition;
            Struct topicPartitionCountStruct = (Struct)topicPartitionCountObj;
            String topic = topicPartitionCountStruct.get(CommonFields.TOPIC_NAME);
            Struct partitionCountStruct = topicPartitionCountStruct.getStruct(NEW_PARTITIONS_KEY_NAME);
            int count = partitionCountStruct.getInt(COUNT_KEY_NAME);
            Object[] assignmentsArray = partitionCountStruct.getArray(ASSIGNMENT_KEY_NAME);
            if (assignmentsArray != null) {
                ArrayList<List<Integer>> assignments = new ArrayList<List<Integer>>(assignmentsArray.length);
                for (Object replicas : assignmentsArray) {
                    Object[] replicasArray = (Object[])replicas;
                    ArrayList<Integer> replicasList = new ArrayList<Integer>(replicasArray.length);
                    assignments.add(replicasList);
                    for (Object broker : replicasArray) {
                        replicasList.add((Integer)broker);
                    }
                }
                newPartition = NewPartitions.increaseTo(count, assignments);
            } else {
                newPartition = NewPartitions.increaseTo(count);
            }
            NewPartitions dupe = counts.put(topic, newPartition);
            if (dupe == null) continue;
            dupes.add(topic);
        }
        this.newPartitions = counts;
        this.duplicates = dupes;
        this.timeout = struct.getInt(TIMEOUT_KEY_NAME);
        this.validateOnly = struct.getBoolean(VALIDATE_ONLY_KEY_NAME);
    }

    public Set<String> duplicates() {
        return this.duplicates;
    }

    public Map<String, NewPartitions> newPartitions() {
        return this.newPartitions;
    }

    public int timeout() {
        return this.timeout;
    }

    public boolean validateOnly() {
        return this.validateOnly;
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.CREATE_PARTITIONS.requestSchema(this.version()));
        ArrayList<Struct> topicPartitionsList = new ArrayList<Struct>();
        for (Map.Entry<String, NewPartitions> topicPartitionCount : this.newPartitions.entrySet()) {
            Struct topicPartitionCountStruct = struct.instance(TOPIC_PARTITIONS_KEY_NAME);
            topicPartitionCountStruct.set(CommonFields.TOPIC_NAME, topicPartitionCount.getKey());
            NewPartitions count = topicPartitionCount.getValue();
            Struct partitionCountStruct = topicPartitionCountStruct.instance(NEW_PARTITIONS_KEY_NAME);
            partitionCountStruct.set(COUNT_KEY_NAME, (Object)count.totalCount());
            Object[][] assignments = null;
            if (count.assignments() != null) {
                assignments = new Object[count.assignments().size()][];
                int i2 = 0;
                for (List<Integer> partitionAssignment : count.assignments()) {
                    assignments[i2] = partitionAssignment.toArray(new Object[0]);
                    ++i2;
                }
            }
            partitionCountStruct.set(ASSIGNMENT_KEY_NAME, (Object)assignments);
            topicPartitionCountStruct.set(NEW_PARTITIONS_KEY_NAME, (Object)partitionCountStruct);
            topicPartitionsList.add(topicPartitionCountStruct);
        }
        struct.set(TOPIC_PARTITIONS_KEY_NAME, (Object)topicPartitionsList.toArray(new Object[0]));
        struct.set(TIMEOUT_KEY_NAME, (Object)this.timeout);
        struct.set(VALIDATE_ONLY_KEY_NAME, (Object)this.validateOnly);
        return struct;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e2) {
        HashMap<String, ApiError> topicErrors = new HashMap<String, ApiError>();
        for (String topic : this.newPartitions.keySet()) {
            topicErrors.put(topic, ApiError.fromThrowable(e2));
        }
        short versionId = this.version();
        switch (versionId) {
            case 0: {
                return new CreatePartitionsResponse(throttleTimeMs, topicErrors);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.CREATE_PARTITIONS.latestVersion()));
    }

    public static CreatePartitionsRequest parse(ByteBuffer buffer, short version) {
        return new CreatePartitionsRequest(ApiKeys.CREATE_PARTITIONS.parseRequest(version, buffer), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<CreatePartitionsRequest> {
        private final Map<String, NewPartitions> newPartitions;
        private final int timeout;
        private final boolean validateOnly;

        public Builder(Map<String, NewPartitions> newPartitions, int timeout, boolean validateOnly) {
            super(ApiKeys.CREATE_PARTITIONS);
            this.newPartitions = newPartitions;
            this.timeout = timeout;
            this.validateOnly = validateOnly;
        }

        @Override
        public CreatePartitionsRequest build(short version) {
            return new CreatePartitionsRequest(this.newPartitions, this.timeout, this.validateOnly, version);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=CreatePartitionsRequest").append(", newPartitions=").append(this.newPartitions).append(", timeout=").append(this.timeout).append(", validateOnly=").append(this.validateOnly).append(")");
            return bld.toString();
        }
    }
}

