/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.InitProducerIdResponse;

public class InitProducerIdRequest
extends AbstractRequest {
    public static final int NO_TRANSACTION_TIMEOUT_MS = Integer.MAX_VALUE;
    private static final String TRANSACTION_TIMEOUT_KEY_NAME = "transaction_timeout_ms";
    private static final Schema INIT_PRODUCER_ID_REQUEST_V0 = new Schema(CommonFields.NULLABLE_TRANSACTIONAL_ID, new Field("transaction_timeout_ms", Type.INT32, "The time in ms to wait for before aborting idle transactions sent by this producer."));
    private final String transactionalId;
    private final int transactionTimeoutMs;

    public static Schema[] schemaVersions() {
        return new Schema[]{INIT_PRODUCER_ID_REQUEST_V0};
    }

    public InitProducerIdRequest(Struct struct, short version) {
        super(version);
        this.transactionalId = struct.get(CommonFields.NULLABLE_TRANSACTIONAL_ID);
        this.transactionTimeoutMs = struct.getInt(TRANSACTION_TIMEOUT_KEY_NAME);
    }

    private InitProducerIdRequest(short version, String transactionalId, int transactionTimeoutMs) {
        super(version);
        this.transactionalId = transactionalId;
        this.transactionTimeoutMs = transactionTimeoutMs;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e2) {
        return new InitProducerIdResponse(throttleTimeMs, Errors.forException(e2));
    }

    public static InitProducerIdRequest parse(ByteBuffer buffer, short version) {
        return new InitProducerIdRequest(ApiKeys.INIT_PRODUCER_ID.parseRequest(version, buffer), version);
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public int transactionTimeoutMs() {
        return this.transactionTimeoutMs;
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.INIT_PRODUCER_ID.requestSchema(this.version()));
        struct.set(CommonFields.NULLABLE_TRANSACTIONAL_ID, this.transactionalId);
        struct.set(TRANSACTION_TIMEOUT_KEY_NAME, (Object)this.transactionTimeoutMs);
        return struct;
    }

    public static class Builder
    extends AbstractRequest.Builder<InitProducerIdRequest> {
        private final String transactionalId;
        private final int transactionTimeoutMs;

        public Builder(String transactionalId) {
            this(transactionalId, Integer.MAX_VALUE);
        }

        public Builder(String transactionalId, int transactionTimeoutMs) {
            super(ApiKeys.INIT_PRODUCER_ID);
            if (transactionTimeoutMs <= 0) {
                throw new IllegalArgumentException("transaction timeout value is not positive: " + transactionTimeoutMs);
            }
            if (transactionalId != null && transactionalId.isEmpty()) {
                throw new IllegalArgumentException("Must set either a null or a non-empty transactional id.");
            }
            this.transactionalId = transactionalId;
            this.transactionTimeoutMs = transactionTimeoutMs;
        }

        @Override
        public InitProducerIdRequest build(short version) {
            return new InitProducerIdRequest(version, this.transactionalId, this.transactionTimeoutMs);
        }

        public String toString() {
            return "(type=InitProducerIdRequest, transactionalId=" + this.transactionalId + ", transactionTimeoutMs=" + this.transactionTimeoutMs + ")";
        }
    }
}

