/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.JoinGroupResponse;
import org.apache.kafka.common.utils.Utils;

public class JoinGroupRequest
extends AbstractRequest {
    private static final String SESSION_TIMEOUT_KEY_NAME = "session_timeout";
    private static final String REBALANCE_TIMEOUT_KEY_NAME = "rebalance_timeout";
    private static final String PROTOCOL_TYPE_KEY_NAME = "protocol_type";
    private static final String GROUP_PROTOCOLS_KEY_NAME = "group_protocols";
    private static final String PROTOCOL_NAME_KEY_NAME = "protocol_name";
    private static final String PROTOCOL_METADATA_KEY_NAME = "protocol_metadata";
    private static final Schema JOIN_GROUP_REQUEST_PROTOCOL_V0 = new Schema(new Field("protocol_name", Type.STRING), new Field("protocol_metadata", Type.BYTES));
    private static final Schema JOIN_GROUP_REQUEST_V0 = new Schema(CommonFields.GROUP_ID, new Field("session_timeout", Type.INT32, "The coordinator considers the consumer dead if it receives no heartbeat after this timeout in ms."), CommonFields.MEMBER_ID, new Field("protocol_type", Type.STRING, "Unique name for class of protocols implemented by group"), new Field("group_protocols", new ArrayOf(JOIN_GROUP_REQUEST_PROTOCOL_V0), "List of protocols that the member supports"));
    private static final Schema JOIN_GROUP_REQUEST_V1;
    private static final Schema JOIN_GROUP_REQUEST_V2;
    public static final String UNKNOWN_MEMBER_ID = "";
    private final String groupId;
    private final int sessionTimeout;
    private final int rebalanceTimeout;
    private final String memberId;
    private final String protocolType;
    private final List<ProtocolMetadata> groupProtocols;

    public static Schema[] schemaVersions() {
        return new Schema[]{JOIN_GROUP_REQUEST_V0, JOIN_GROUP_REQUEST_V1, JOIN_GROUP_REQUEST_V2};
    }

    private JoinGroupRequest(short version, String groupId, int sessionTimeout, int rebalanceTimeout, String memberId, String protocolType, List<ProtocolMetadata> groupProtocols) {
        super(version);
        this.groupId = groupId;
        this.sessionTimeout = sessionTimeout;
        this.rebalanceTimeout = rebalanceTimeout;
        this.memberId = memberId;
        this.protocolType = protocolType;
        this.groupProtocols = groupProtocols;
    }

    public JoinGroupRequest(Struct struct, short versionId) {
        super(versionId);
        this.groupId = struct.get(CommonFields.GROUP_ID);
        this.sessionTimeout = struct.getInt(SESSION_TIMEOUT_KEY_NAME);
        this.rebalanceTimeout = struct.hasField(REBALANCE_TIMEOUT_KEY_NAME) ? struct.getInt(REBALANCE_TIMEOUT_KEY_NAME) : this.sessionTimeout;
        this.memberId = struct.get(CommonFields.MEMBER_ID);
        this.protocolType = struct.getString(PROTOCOL_TYPE_KEY_NAME);
        this.groupProtocols = new ArrayList<ProtocolMetadata>();
        for (Object groupProtocolObj : struct.getArray(GROUP_PROTOCOLS_KEY_NAME)) {
            Struct groupProtocolStruct = (Struct)groupProtocolObj;
            String name = groupProtocolStruct.getString(PROTOCOL_NAME_KEY_NAME);
            ByteBuffer metadata = groupProtocolStruct.getBytes(PROTOCOL_METADATA_KEY_NAME);
            this.groupProtocols.add(new ProtocolMetadata(name, metadata));
        }
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e2) {
        short versionId = this.version();
        switch (versionId) {
            case 0: 
            case 1: {
                return new JoinGroupResponse(Errors.forException(e2), -1, UNKNOWN_MEMBER_ID, UNKNOWN_MEMBER_ID, UNKNOWN_MEMBER_ID, Collections.emptyMap());
            }
            case 2: {
                return new JoinGroupResponse(throttleTimeMs, Errors.forException(e2), -1, UNKNOWN_MEMBER_ID, UNKNOWN_MEMBER_ID, UNKNOWN_MEMBER_ID, Collections.emptyMap());
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.JOIN_GROUP.latestVersion()));
    }

    public String groupId() {
        return this.groupId;
    }

    public int sessionTimeout() {
        return this.sessionTimeout;
    }

    public int rebalanceTimeout() {
        return this.rebalanceTimeout;
    }

    public String memberId() {
        return this.memberId;
    }

    public List<ProtocolMetadata> groupProtocols() {
        return this.groupProtocols;
    }

    public String protocolType() {
        return this.protocolType;
    }

    public static JoinGroupRequest parse(ByteBuffer buffer, short version) {
        return new JoinGroupRequest(ApiKeys.JOIN_GROUP.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        short version = this.version();
        Struct struct = new Struct(ApiKeys.JOIN_GROUP.requestSchema(version));
        struct.set(CommonFields.GROUP_ID, this.groupId);
        struct.set(SESSION_TIMEOUT_KEY_NAME, (Object)this.sessionTimeout);
        if (version >= 1) {
            struct.set(REBALANCE_TIMEOUT_KEY_NAME, (Object)this.rebalanceTimeout);
        }
        struct.set(CommonFields.MEMBER_ID, this.memberId);
        struct.set(PROTOCOL_TYPE_KEY_NAME, (Object)this.protocolType);
        ArrayList<Struct> groupProtocolsList = new ArrayList<Struct>(this.groupProtocols.size());
        for (ProtocolMetadata protocol : this.groupProtocols) {
            Struct protocolStruct = struct.instance(GROUP_PROTOCOLS_KEY_NAME);
            protocolStruct.set(PROTOCOL_NAME_KEY_NAME, (Object)protocol.name);
            protocolStruct.set(PROTOCOL_METADATA_KEY_NAME, (Object)protocol.metadata);
            groupProtocolsList.add(protocolStruct);
        }
        struct.set(GROUP_PROTOCOLS_KEY_NAME, (Object)groupProtocolsList.toArray());
        return struct;
    }

    static {
        JOIN_GROUP_REQUEST_V2 = JOIN_GROUP_REQUEST_V1 = new Schema(CommonFields.GROUP_ID, new Field(SESSION_TIMEOUT_KEY_NAME, Type.INT32, "The coordinator considers the consumer dead if it receives no heartbeat after this timeout in ms."), new Field(REBALANCE_TIMEOUT_KEY_NAME, Type.INT32, "The maximum time that the coordinator will wait for each member to rejoin when rebalancing the group"), CommonFields.MEMBER_ID, new Field(PROTOCOL_TYPE_KEY_NAME, Type.STRING, "Unique name for class of protocols implemented by group"), new Field(GROUP_PROTOCOLS_KEY_NAME, new ArrayOf(JOIN_GROUP_REQUEST_PROTOCOL_V0), "List of protocols that the member supports"));
    }

    public static class Builder
    extends AbstractRequest.Builder<JoinGroupRequest> {
        private final String groupId;
        private final int sessionTimeout;
        private final String memberId;
        private final String protocolType;
        private final List<ProtocolMetadata> groupProtocols;
        private int rebalanceTimeout = 0;

        public Builder(String groupId, int sessionTimeout, String memberId, String protocolType, List<ProtocolMetadata> groupProtocols) {
            super(ApiKeys.JOIN_GROUP);
            this.groupId = groupId;
            this.sessionTimeout = sessionTimeout;
            this.rebalanceTimeout = sessionTimeout;
            this.memberId = memberId;
            this.protocolType = protocolType;
            this.groupProtocols = groupProtocols;
        }

        public Builder setRebalanceTimeout(int rebalanceTimeout) {
            this.rebalanceTimeout = rebalanceTimeout;
            return this;
        }

        @Override
        public JoinGroupRequest build(short version) {
            if (version < 1) {
                this.rebalanceTimeout = this.sessionTimeout;
            }
            return new JoinGroupRequest(version, this.groupId, this.sessionTimeout, this.rebalanceTimeout, this.memberId, this.protocolType, this.groupProtocols);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type: JoinGroupRequest").append(", groupId=").append(this.groupId).append(", sessionTimeout=").append(this.sessionTimeout).append(", rebalanceTimeout=").append(this.rebalanceTimeout).append(", memberId=").append(this.memberId).append(", protocolType=").append(this.protocolType).append(", groupProtocols=").append(Utils.join(this.groupProtocols, ", ")).append(")");
            return bld.toString();
        }
    }

    public static class ProtocolMetadata {
        private final String name;
        private final ByteBuffer metadata;

        public ProtocolMetadata(String name, ByteBuffer metadata) {
            this.name = name;
            this.metadata = metadata;
        }

        public String name() {
            return this.name;
        }

        public ByteBuffer metadata() {
            return this.metadata;
        }
    }
}

