/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.SaslAuthenticateResponse;

public class SaslAuthenticateRequest
extends AbstractRequest {
    private static final String SASL_AUTH_BYTES_KEY_NAME = "sasl_auth_bytes";
    private static final Schema SASL_AUTHENTICATE_REQUEST_V0 = new Schema(new Field("sasl_auth_bytes", Type.BYTES, "SASL authentication bytes from client as defined by the SASL mechanism."));
    private final ByteBuffer saslAuthBytes;

    public static Schema[] schemaVersions() {
        return new Schema[]{SASL_AUTHENTICATE_REQUEST_V0};
    }

    public SaslAuthenticateRequest(ByteBuffer saslAuthBytes) {
        this(saslAuthBytes, ApiKeys.SASL_AUTHENTICATE.latestVersion());
    }

    public SaslAuthenticateRequest(ByteBuffer saslAuthBytes, short version) {
        super(version);
        this.saslAuthBytes = saslAuthBytes;
    }

    public SaslAuthenticateRequest(Struct struct, short version) {
        super(version);
        this.saslAuthBytes = struct.getBytes(SASL_AUTH_BYTES_KEY_NAME);
    }

    public ByteBuffer saslAuthBytes() {
        return this.saslAuthBytes;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e2) {
        short versionId = this.version();
        switch (versionId) {
            case 0: {
                return new SaslAuthenticateResponse(Errors.forException(e2), e2.getMessage());
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.SASL_AUTHENTICATE.latestVersion()));
    }

    public static SaslAuthenticateRequest parse(ByteBuffer buffer, short version) {
        return new SaslAuthenticateRequest(ApiKeys.SASL_AUTHENTICATE.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.SASL_AUTHENTICATE.requestSchema(this.version()));
        struct.set(SASL_AUTH_BYTES_KEY_NAME, (Object)this.saslAuthBytes);
        return struct;
    }

    public static class Builder
    extends AbstractRequest.Builder<SaslAuthenticateRequest> {
        private final ByteBuffer saslAuthBytes;

        public Builder(ByteBuffer saslAuthBytes) {
            super(ApiKeys.SASL_AUTHENTICATE);
            this.saslAuthBytes = saslAuthBytes;
        }

        @Override
        public SaslAuthenticateRequest build(short version) {
            return new SaslAuthenticateRequest(this.saslAuthBytes, version);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=SaslAuthenticateRequest)");
            return bld.toString();
        }
    }
}

