/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.SaslHandshakeResponse;

public class SaslHandshakeRequest
extends AbstractRequest {
    private static final String MECHANISM_KEY_NAME = "mechanism";
    private static final Schema SASL_HANDSHAKE_REQUEST_V0;
    private static final Schema SASL_HANDSHAKE_REQUEST_V1;
    private final String mechanism;

    public static Schema[] schemaVersions() {
        return new Schema[]{SASL_HANDSHAKE_REQUEST_V0, SASL_HANDSHAKE_REQUEST_V1};
    }

    public SaslHandshakeRequest(String mechanism) {
        this(mechanism, ApiKeys.SASL_HANDSHAKE.latestVersion());
    }

    public SaslHandshakeRequest(String mechanism, short version) {
        super(version);
        this.mechanism = mechanism;
    }

    public SaslHandshakeRequest(Struct struct, short version) {
        super(version);
        this.mechanism = struct.getString(MECHANISM_KEY_NAME);
    }

    public String mechanism() {
        return this.mechanism;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e2) {
        short versionId = this.version();
        switch (versionId) {
            case 0: 
            case 1: {
                List<String> enabledMechanisms = Collections.emptyList();
                return new SaslHandshakeResponse(Errors.forException(e2), enabledMechanisms);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.SASL_HANDSHAKE.latestVersion()));
    }

    public static SaslHandshakeRequest parse(ByteBuffer buffer, short version) {
        return new SaslHandshakeRequest(ApiKeys.SASL_HANDSHAKE.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.SASL_HANDSHAKE.requestSchema(this.version()));
        struct.set(MECHANISM_KEY_NAME, (Object)this.mechanism);
        return struct;
    }

    static {
        SASL_HANDSHAKE_REQUEST_V1 = SASL_HANDSHAKE_REQUEST_V0 = new Schema(new Field(MECHANISM_KEY_NAME, Type.STRING, "SASL Mechanism chosen by the client."));
    }

    public static class Builder
    extends AbstractRequest.Builder<SaslHandshakeRequest> {
        private final String mechanism;

        public Builder(String mechanism) {
            super(ApiKeys.SASL_HANDSHAKE);
            this.mechanism = mechanism;
        }

        @Override
        public SaslHandshakeRequest build(short version) {
            return new SaslHandshakeRequest(this.mechanism, version);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=SaslHandshakeRequest").append(", mechanism=").append(this.mechanism).append(")");
            return bld.toString();
        }
    }
}

