/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.BasePartitionState;
import org.apache.kafka.common.requests.UpdateMetadataResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;

public class UpdateMetadataRequest
extends AbstractRequest {
    private static final String CONTROLLER_ID_KEY_NAME = "controller_id";
    private static final String CONTROLLER_EPOCH_KEY_NAME = "controller_epoch";
    private static final String PARTITION_STATES_KEY_NAME = "partition_states";
    private static final String LIVE_BROKERS_KEY_NAME = "live_brokers";
    private static final String LEADER_KEY_NAME = "leader";
    private static final String LEADER_EPOCH_KEY_NAME = "leader_epoch";
    private static final String ISR_KEY_NAME = "isr";
    private static final String ZK_VERSION_KEY_NAME = "zk_version";
    private static final String REPLICAS_KEY_NAME = "replicas";
    private static final String OFFLINE_REPLICAS_KEY_NAME = "offline_replicas";
    private static final String BROKER_ID_KEY_NAME = "id";
    private static final String ENDPOINTS_KEY_NAME = "end_points";
    private static final String RACK_KEY_NAME = "rack";
    private static final String HOST_KEY_NAME = "host";
    private static final String PORT_KEY_NAME = "port";
    private static final String LISTENER_NAME_KEY_NAME = "listener_name";
    private static final String SECURITY_PROTOCOL_TYPE_KEY_NAME = "security_protocol_type";
    private static final Schema UPDATE_METADATA_REQUEST_PARTITION_STATE_V0 = new Schema(CommonFields.TOPIC_NAME, CommonFields.PARTITION_ID, new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("leader", Type.INT32, "The broker id for the leader."), new Field("leader_epoch", Type.INT32, "The leader epoch."), new Field("isr", new ArrayOf(Type.INT32), "The in sync replica ids."), new Field("zk_version", Type.INT32, "The ZK version."), new Field("replicas", new ArrayOf(Type.INT32), "The replica ids."));
    private static final Schema UPDATE_METADATA_REQUEST_BROKER_V0 = new Schema(new Field("id", Type.INT32, "The broker id."), new Field("host", Type.STRING, "The hostname of the broker."), new Field("port", Type.INT32, "The port on which the broker accepts requests."));
    private static final Schema UPDATE_METADATA_REQUEST_V0 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("partition_states", new ArrayOf(UPDATE_METADATA_REQUEST_PARTITION_STATE_V0)), new Field("live_brokers", new ArrayOf(UPDATE_METADATA_REQUEST_BROKER_V0)));
    private static final Schema UPDATE_METADATA_REQUEST_PARTITION_STATE_V1 = UPDATE_METADATA_REQUEST_PARTITION_STATE_V0;
    private static final Schema UPDATE_METADATA_REQUEST_END_POINT_V1 = new Schema(new Field("port", Type.INT32, "The port on which the broker accepts requests."), new Field("host", Type.STRING, "The hostname of the broker."), new Field("security_protocol_type", Type.INT16, "The security protocol type."));
    private static final Schema UPDATE_METADATA_REQUEST_BROKER_V1 = new Schema(new Field("id", Type.INT32, "The broker id."), new Field("end_points", new ArrayOf(UPDATE_METADATA_REQUEST_END_POINT_V1)));
    private static final Schema UPDATE_METADATA_REQUEST_V1 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("partition_states", new ArrayOf(UPDATE_METADATA_REQUEST_PARTITION_STATE_V1)), new Field("live_brokers", new ArrayOf(UPDATE_METADATA_REQUEST_BROKER_V1)));
    private static final Schema UPDATE_METADATA_REQUEST_PARTITION_STATE_V2 = UPDATE_METADATA_REQUEST_PARTITION_STATE_V1;
    private static final Schema UPDATE_METADATA_REQUEST_END_POINT_V2 = UPDATE_METADATA_REQUEST_END_POINT_V1;
    private static final Schema UPDATE_METADATA_REQUEST_BROKER_V2 = new Schema(new Field("id", Type.INT32, "The broker id."), new Field("end_points", new ArrayOf(UPDATE_METADATA_REQUEST_END_POINT_V2)), new Field("rack", Type.NULLABLE_STRING, "The rack"));
    private static final Schema UPDATE_METADATA_REQUEST_V2 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("partition_states", new ArrayOf(UPDATE_METADATA_REQUEST_PARTITION_STATE_V2)), new Field("live_brokers", new ArrayOf(UPDATE_METADATA_REQUEST_BROKER_V2)));
    private static final Schema UPDATE_METADATA_REQUEST_PARTITION_STATE_V3 = UPDATE_METADATA_REQUEST_PARTITION_STATE_V2;
    private static final Schema UPDATE_METADATA_REQUEST_PARTITION_STATE_V4 = new Schema(CommonFields.TOPIC_NAME, CommonFields.PARTITION_ID, new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("leader", Type.INT32, "The broker id for the leader."), new Field("leader_epoch", Type.INT32, "The leader epoch."), new Field("isr", new ArrayOf(Type.INT32), "The in sync replica ids."), new Field("zk_version", Type.INT32, "The ZK version."), new Field("replicas", new ArrayOf(Type.INT32), "The replica ids."), new Field("offline_replicas", new ArrayOf(Type.INT32), "The offline replica ids"));
    private static final Schema UPDATE_METADATA_REQUEST_END_POINT_V3 = new Schema(new Field("port", Type.INT32, "The port on which the broker accepts requests."), new Field("host", Type.STRING, "The hostname of the broker."), new Field("listener_name", Type.STRING, "The listener name."), new Field("security_protocol_type", Type.INT16, "The security protocol type."));
    private static final Schema UPDATE_METADATA_REQUEST_BROKER_V3 = new Schema(new Field("id", Type.INT32, "The broker id."), new Field("end_points", new ArrayOf(UPDATE_METADATA_REQUEST_END_POINT_V3)), new Field("rack", Type.NULLABLE_STRING, "The rack"));
    private static final Schema UPDATE_METADATA_REQUEST_V3 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("partition_states", new ArrayOf(UPDATE_METADATA_REQUEST_PARTITION_STATE_V3)), new Field("live_brokers", new ArrayOf(UPDATE_METADATA_REQUEST_BROKER_V3)));
    private static final Schema UPDATE_METADATA_REQUEST_V4 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("partition_states", new ArrayOf(UPDATE_METADATA_REQUEST_PARTITION_STATE_V4)), new Field("live_brokers", new ArrayOf(UPDATE_METADATA_REQUEST_BROKER_V3)));
    private final int controllerId;
    private final int controllerEpoch;
    private final Map<TopicPartition, PartitionState> partitionStates;
    private final Set<Broker> liveBrokers;

    public static Schema[] schemaVersions() {
        return new Schema[]{UPDATE_METADATA_REQUEST_V0, UPDATE_METADATA_REQUEST_V1, UPDATE_METADATA_REQUEST_V2, UPDATE_METADATA_REQUEST_V3, UPDATE_METADATA_REQUEST_V4};
    }

    private UpdateMetadataRequest(short version, int controllerId, int controllerEpoch, Map<TopicPartition, PartitionState> partitionStates, Set<Broker> liveBrokers) {
        super(version);
        this.controllerId = controllerId;
        this.controllerEpoch = controllerEpoch;
        this.partitionStates = partitionStates;
        this.liveBrokers = liveBrokers;
    }

    public UpdateMetadataRequest(Struct struct, short versionId) {
        super(versionId);
        HashMap<TopicPartition, PartitionState> partitionStates = new HashMap<TopicPartition, PartitionState>();
        for (Object partitionStateDataObj : struct.getArray(PARTITION_STATES_KEY_NAME)) {
            Struct partitionStateData = (Struct)partitionStateDataObj;
            String topic = partitionStateData.get(CommonFields.TOPIC_NAME);
            int partition = partitionStateData.get(CommonFields.PARTITION_ID);
            int controllerEpoch = partitionStateData.getInt(CONTROLLER_EPOCH_KEY_NAME);
            int leader = partitionStateData.getInt(LEADER_KEY_NAME);
            int leaderEpoch = partitionStateData.getInt(LEADER_EPOCH_KEY_NAME);
            Object[] isrArray = partitionStateData.getArray(ISR_KEY_NAME);
            ArrayList<Integer> isr = new ArrayList<Integer>(isrArray.length);
            for (Object r2 : isrArray) {
                isr.add((Integer)r2);
            }
            int zkVersion = partitionStateData.getInt(ZK_VERSION_KEY_NAME);
            Object[] replicasArray = partitionStateData.getArray(REPLICAS_KEY_NAME);
            ArrayList<Integer> replicas = new ArrayList<Integer>(replicasArray.length);
            for (Object r3 : replicasArray) {
                replicas.add((Integer)r3);
            }
            ArrayList<Integer> offlineReplicas = new ArrayList<Integer>();
            if (partitionStateData.hasField(OFFLINE_REPLICAS_KEY_NAME)) {
                Object[] offlineReplicasArray;
                for (Object r4 : offlineReplicasArray = partitionStateData.getArray(OFFLINE_REPLICAS_KEY_NAME)) {
                    offlineReplicas.add((Integer)r4);
                }
            }
            PartitionState partitionState = new PartitionState(controllerEpoch, leader, leaderEpoch, isr, zkVersion, replicas, offlineReplicas);
            partitionStates.put(new TopicPartition(topic, partition), partitionState);
        }
        HashSet<Broker> liveBrokers = new HashSet<Broker>();
        for (Object brokerDataObj : struct.getArray(LIVE_BROKERS_KEY_NAME)) {
            Struct brokerData = (Struct)brokerDataObj;
            int brokerId = brokerData.getInt(BROKER_ID_KEY_NAME);
            if (brokerData.hasField(HOST_KEY_NAME)) {
                String host = brokerData.getString(HOST_KEY_NAME);
                int port = brokerData.getInt(PORT_KEY_NAME);
                ArrayList<EndPoint> endPoints = new ArrayList<EndPoint>(1);
                SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
                endPoints.add(new EndPoint(host, port, securityProtocol, ListenerName.forSecurityProtocol(securityProtocol)));
                liveBrokers.add(new Broker(brokerId, endPoints, null));
                continue;
            }
            ArrayList<EndPoint> endPoints = new ArrayList<EndPoint>();
            for (Object endPointDataObj : brokerData.getArray(ENDPOINTS_KEY_NAME)) {
                Struct endPointData = (Struct)endPointDataObj;
                int port = endPointData.getInt(PORT_KEY_NAME);
                String host = endPointData.getString(HOST_KEY_NAME);
                short protocolTypeId = endPointData.getShort(SECURITY_PROTOCOL_TYPE_KEY_NAME);
                SecurityProtocol securityProtocol = SecurityProtocol.forId(protocolTypeId);
                String listenerName = endPointData.hasField(LISTENER_NAME_KEY_NAME) ? endPointData.getString(LISTENER_NAME_KEY_NAME) : securityProtocol.name;
                endPoints.add(new EndPoint(host, port, securityProtocol, new ListenerName(listenerName)));
            }
            String rack = null;
            if (brokerData.hasField(RACK_KEY_NAME)) {
                rack = brokerData.getString(RACK_KEY_NAME);
            }
            liveBrokers.add(new Broker(brokerId, endPoints, rack));
        }
        this.controllerId = struct.getInt(CONTROLLER_ID_KEY_NAME);
        this.controllerEpoch = struct.getInt(CONTROLLER_EPOCH_KEY_NAME);
        this.partitionStates = partitionStates;
        this.liveBrokers = liveBrokers;
    }

    @Override
    protected Struct toStruct() {
        short version = this.version();
        Struct struct = new Struct(ApiKeys.UPDATE_METADATA.requestSchema(version));
        struct.set(CONTROLLER_ID_KEY_NAME, (Object)this.controllerId);
        struct.set(CONTROLLER_EPOCH_KEY_NAME, (Object)this.controllerEpoch);
        ArrayList<Struct> partitionStatesData = new ArrayList<Struct>(this.partitionStates.size());
        for (Map.Entry<TopicPartition, PartitionState> entry : this.partitionStates.entrySet()) {
            Struct partitionStateData = struct.instance(PARTITION_STATES_KEY_NAME);
            TopicPartition topicPartition = entry.getKey();
            partitionStateData.set(CommonFields.TOPIC_NAME, topicPartition.topic());
            partitionStateData.set(CommonFields.PARTITION_ID, topicPartition.partition());
            PartitionState partitionState = entry.getValue();
            partitionStateData.set(CONTROLLER_EPOCH_KEY_NAME, (Object)partitionState.basePartitionState.controllerEpoch);
            partitionStateData.set(LEADER_KEY_NAME, (Object)partitionState.basePartitionState.leader);
            partitionStateData.set(LEADER_EPOCH_KEY_NAME, (Object)partitionState.basePartitionState.leaderEpoch);
            partitionStateData.set(ISR_KEY_NAME, (Object)partitionState.basePartitionState.isr.toArray());
            partitionStateData.set(ZK_VERSION_KEY_NAME, (Object)partitionState.basePartitionState.zkVersion);
            partitionStateData.set(REPLICAS_KEY_NAME, (Object)partitionState.basePartitionState.replicas.toArray());
            if (partitionStateData.hasField(OFFLINE_REPLICAS_KEY_NAME)) {
                partitionStateData.set(OFFLINE_REPLICAS_KEY_NAME, (Object)partitionState.offlineReplicas.toArray());
            }
            partitionStatesData.add(partitionStateData);
        }
        struct.set(PARTITION_STATES_KEY_NAME, (Object)partitionStatesData.toArray());
        ArrayList<Struct> brokersData = new ArrayList<Struct>(this.liveBrokers.size());
        for (Broker broker : this.liveBrokers) {
            Struct brokerData = struct.instance(LIVE_BROKERS_KEY_NAME);
            brokerData.set(BROKER_ID_KEY_NAME, (Object)broker.id);
            if (version == 0) {
                EndPoint endPoint = broker.endPoints.get(0);
                brokerData.set(HOST_KEY_NAME, (Object)endPoint.host);
                brokerData.set(PORT_KEY_NAME, (Object)endPoint.port);
            } else {
                ArrayList<Struct> endPointsData = new ArrayList<Struct>(broker.endPoints.size());
                for (EndPoint endPoint : broker.endPoints) {
                    Struct endPointData = brokerData.instance(ENDPOINTS_KEY_NAME);
                    endPointData.set(PORT_KEY_NAME, (Object)endPoint.port);
                    endPointData.set(HOST_KEY_NAME, (Object)endPoint.host);
                    endPointData.set(SECURITY_PROTOCOL_TYPE_KEY_NAME, (Object)endPoint.securityProtocol.id);
                    if (version >= 3) {
                        endPointData.set(LISTENER_NAME_KEY_NAME, (Object)endPoint.listenerName.value());
                    }
                    endPointsData.add(endPointData);
                }
                brokerData.set(ENDPOINTS_KEY_NAME, (Object)endPointsData.toArray());
                if (version >= 2) {
                    brokerData.set(RACK_KEY_NAME, (Object)broker.rack);
                }
            }
            brokersData.add(brokerData);
        }
        struct.set(LIVE_BROKERS_KEY_NAME, (Object)brokersData.toArray());
        return struct;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e2) {
        short versionId = this.version();
        if (versionId <= 4) {
            return new UpdateMetadataResponse(Errors.forException(e2));
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.UPDATE_METADATA.latestVersion()));
    }

    public int controllerId() {
        return this.controllerId;
    }

    public int controllerEpoch() {
        return this.controllerEpoch;
    }

    public Map<TopicPartition, PartitionState> partitionStates() {
        return this.partitionStates;
    }

    public Set<Broker> liveBrokers() {
        return this.liveBrokers;
    }

    public static UpdateMetadataRequest parse(ByteBuffer buffer, short version) {
        return new UpdateMetadataRequest(ApiKeys.UPDATE_METADATA.parseRequest(version, buffer), version);
    }

    public static final class EndPoint {
        public final String host;
        public final int port;
        public final SecurityProtocol securityProtocol;
        public final ListenerName listenerName;

        public EndPoint(String host, int port, SecurityProtocol securityProtocol, ListenerName listenerName) {
            this.host = host;
            this.port = port;
            this.securityProtocol = securityProtocol;
            this.listenerName = listenerName;
        }

        public String toString() {
            return "(host=" + this.host + ", port=" + this.port + ", listenerName=" + this.listenerName + ", securityProtocol=" + (Object)((Object)this.securityProtocol) + ")";
        }
    }

    public static final class Broker {
        public final int id;
        public final List<EndPoint> endPoints;
        public final String rack;

        public Broker(int id, List<EndPoint> endPoints, String rack) {
            this.id = id;
            this.endPoints = endPoints;
            this.rack = rack;
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(id=").append(this.id);
            bld.append(", endPoints=").append(Utils.join(this.endPoints, ","));
            bld.append(", rack=").append(this.rack);
            bld.append(")");
            return bld.toString();
        }
    }

    public static final class PartitionState {
        public final BasePartitionState basePartitionState;
        public final List<Integer> offlineReplicas;

        public PartitionState(int controllerEpoch, int leader, int leaderEpoch, List<Integer> isr, int zkVersion, List<Integer> replicas, List<Integer> offlineReplicas) {
            this.basePartitionState = new BasePartitionState(controllerEpoch, leader, leaderEpoch, isr, zkVersion, replicas);
            this.offlineReplicas = offlineReplicas;
        }

        public String toString() {
            return "PartitionState(controllerEpoch=" + this.basePartitionState.controllerEpoch + ", leader=" + this.basePartitionState.leader + ", leaderEpoch=" + this.basePartitionState.leaderEpoch + ", isr=" + Arrays.toString(this.basePartitionState.isr.toArray()) + ", zkVersion=" + this.basePartitionState.zkVersion + ", replicas=" + Arrays.toString(this.basePartitionState.replicas.toArray()) + ", offlineReplicas=" + Arrays.toString(this.offlineReplicas.toArray()) + ")";
        }
    }

    public static class Builder
    extends AbstractRequest.Builder<UpdateMetadataRequest> {
        private final int controllerId;
        private final int controllerEpoch;
        private final Map<TopicPartition, PartitionState> partitionStates;
        private final Set<Broker> liveBrokers;

        public Builder(short version, int controllerId, int controllerEpoch, Map<TopicPartition, PartitionState> partitionStates, Set<Broker> liveBrokers) {
            super(ApiKeys.UPDATE_METADATA, version);
            this.controllerId = controllerId;
            this.controllerEpoch = controllerEpoch;
            this.partitionStates = partitionStates;
            this.liveBrokers = liveBrokers;
        }

        @Override
        public UpdateMetadataRequest build(short version) {
            if (version == 0) {
                for (Broker broker : this.liveBrokers) {
                    if (broker.endPoints.size() == 1 && broker.endPoints.get((int)0).securityProtocol == SecurityProtocol.PLAINTEXT) continue;
                    throw new UnsupportedVersionException("UpdateMetadataRequest v0 only handles PLAINTEXT endpoints");
                }
            }
            return new UpdateMetadataRequest(version, this.controllerId, this.controllerEpoch, this.partitionStates, this.liveBrokers);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type: UpdateMetadataRequest=").append(", controllerId=").append(this.controllerId).append(", controllerEpoch=").append(this.controllerEpoch).append(", partitionStates=").append(this.partitionStates).append(", liveBrokers=").append(Utils.join(this.liveBrokers, ", ")).append(")");
            return bld.toString();
        }
    }
}

