/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.auth;

import java.security.Principal;
import java.util.Objects;
import org.apache.kafka.common.utils.SecurityUtils;

public class KafkaPrincipal
implements Principal {
    public static final String USER_TYPE = "User";
    public static final KafkaPrincipal ANONYMOUS = new KafkaPrincipal("User", "ANONYMOUS");
    private final String principalType;
    private final String name;

    public KafkaPrincipal(String principalType, String name) {
        this.principalType = Objects.requireNonNull(principalType, "Principal type cannot be null");
        this.name = Objects.requireNonNull(name, "Principal name cannot be null");
    }

    @Deprecated
    public static KafkaPrincipal fromString(String str) {
        return SecurityUtils.parseKafkaPrincipal(str);
    }

    @Override
    public String toString() {
        return this.principalType + ":" + this.name;
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null) {
            return false;
        }
        if (this.getClass() != o2.getClass()) {
            return false;
        }
        KafkaPrincipal that = (KafkaPrincipal)o2;
        return this.principalType.equals(that.principalType) && this.name.equals(that.name);
    }

    @Override
    public int hashCode() {
        int result = this.principalType.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getPrincipalType() {
        return this.principalType;
    }
}

