/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.serialization;

import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;

public class IntegerDeserializer
implements Deserializer<Integer> {
    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    @Override
    public Integer deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        if (data.length != 4) {
            throw new SerializationException("Size of data received by IntegerDeserializer is not 4");
        }
        int value = 0;
        for (byte b2 : data) {
            value <<= 8;
            value |= b2 & 0xFF;
        }
        return value;
    }

    @Override
    public void close() {
    }
}

