/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.apache.kafka.common.utils.Java;

public final class Base64 {
    private static final Factory FACTORY = Java.IS_JAVA8_COMPATIBLE ? new Java8Factory() : new Java7Factory();

    private Base64() {
    }

    public static Encoder encoder() {
        return FACTORY.encoder();
    }

    public static Encoder urlEncoderNoPadding() {
        return FACTORY.urlEncoderNoPadding();
    }

    public static Decoder decoder() {
        return FACTORY.decoder();
    }

    private static class Java7Factory
    implements Factory {
        private static final MethodHandle PRINT;
        private static final MethodHandle PARSE;
        public static final Encoder URL_ENCODER_NO_PADDING;
        public static final Encoder ENCODER;
        public static final Decoder DECODER;

        private Java7Factory() {
        }

        private static String encodeToString(byte[] bytes) {
            try {
                return PRINT.invokeExact(bytes);
            }
            catch (Throwable throwable) {
                throw (RuntimeException)throwable;
            }
        }

        @Override
        public Encoder urlEncoderNoPadding() {
            return URL_ENCODER_NO_PADDING;
        }

        @Override
        public Encoder encoder() {
            return ENCODER;
        }

        @Override
        public Decoder decoder() {
            return DECODER;
        }

        static {
            try {
                Class<?> cls = Class.forName("javax.xml.bind.DatatypeConverter");
                MethodHandles.Lookup lookup = MethodHandles.publicLookup();
                PRINT = lookup.findStatic(cls, "printBase64Binary", MethodType.methodType(String.class, byte[].class));
                PARSE = lookup.findStatic(cls, "parseBase64Binary", MethodType.methodType(byte[].class, String.class));
            }
            catch (ReflectiveOperationException e2) {
                throw new RuntimeException(e2);
            }
            URL_ENCODER_NO_PADDING = new Encoder(){

                @Override
                public String encodeToString(byte[] bytes) {
                    String base64EncodedUUID = Java7Factory.encodeToString(bytes);
                    String urlSafeBase64EncodedUUID = base64EncodedUUID.replace("+", "-").replace("/", "_");
                    return urlSafeBase64EncodedUUID.substring(0, urlSafeBase64EncodedUUID.length() - 2);
                }
            };
            ENCODER = new Encoder(){

                @Override
                public String encodeToString(byte[] bytes) {
                    return Java7Factory.encodeToString(bytes);
                }
            };
            DECODER = new Decoder(){

                @Override
                public byte[] decode(String string) {
                    try {
                        return PARSE.invokeExact(string);
                    }
                    catch (Throwable throwable) {
                        throw (RuntimeException)throwable;
                    }
                }
            };
        }
    }

    private static class Java8Factory
    implements Factory {
        private static final MethodHandle URL_ENCODE_NO_PADDING;
        private static final MethodHandle ENCODE;
        private static final MethodHandle DECODE;
        private static final Encoder URL_ENCODER_NO_PADDING;
        private static final Encoder ENCODER;
        private static final Decoder DECODER;

        private Java8Factory() {
        }

        @Override
        public Encoder urlEncoderNoPadding() {
            return URL_ENCODER_NO_PADDING;
        }

        @Override
        public Encoder encoder() {
            return ENCODER;
        }

        @Override
        public Decoder decoder() {
            return DECODER;
        }

        static {
            try {
                Object juUrlEncoderNoPassing;
                Object juEncoder;
                Class<?> base64Class = Class.forName("java.util.Base64");
                MethodHandles.Lookup lookup = MethodHandles.publicLookup();
                Class<?> juEncoderClass = Class.forName("java.util.Base64$Encoder");
                MethodHandle getEncoder = lookup.findStatic(base64Class, "getEncoder", MethodType.methodType(juEncoderClass));
                try {
                    juEncoder = getEncoder.invoke();
                }
                catch (Throwable throwable) {
                    throw (RuntimeException)throwable;
                }
                MethodHandle encode = lookup.findVirtual(juEncoderClass, "encodeToString", MethodType.methodType(String.class, byte[].class));
                ENCODE = encode.bindTo(juEncoder);
                MethodHandle getUrlEncoder = lookup.findStatic(base64Class, "getUrlEncoder", MethodType.methodType(juEncoderClass));
                try {
                    juUrlEncoderNoPassing = lookup.findVirtual(juEncoderClass, "withoutPadding", MethodType.methodType(juEncoderClass)).invoke(getUrlEncoder.invoke());
                }
                catch (Throwable throwable) {
                    throw (RuntimeException)throwable;
                }
                URL_ENCODE_NO_PADDING = encode.bindTo(juUrlEncoderNoPassing);
                Class<?> juDecoderClass = Class.forName("java.util.Base64$Decoder");
                MethodHandle getDecoder = lookup.findStatic(base64Class, "getDecoder", MethodType.methodType(juDecoderClass));
                MethodHandle decode = lookup.findVirtual(juDecoderClass, "decode", MethodType.methodType(byte[].class, String.class));
                try {
                    DECODE = decode.bindTo(getDecoder.invoke());
                }
                catch (Throwable throwable) {
                    throw (RuntimeException)throwable;
                }
                URL_ENCODER_NO_PADDING = new Encoder(){

                    @Override
                    public String encodeToString(byte[] bytes) {
                        try {
                            return URL_ENCODE_NO_PADDING.invokeExact(bytes);
                        }
                        catch (Throwable throwable) {
                            throw (RuntimeException)throwable;
                        }
                    }
                };
                ENCODER = new Encoder(){

                    @Override
                    public String encodeToString(byte[] bytes) {
                        try {
                            return ENCODE.invokeExact(bytes);
                        }
                        catch (Throwable throwable) {
                            throw (RuntimeException)throwable;
                        }
                    }
                };
                DECODER = new Decoder(){

                    @Override
                    public byte[] decode(String string) {
                        try {
                            return DECODE.invokeExact(string);
                        }
                        catch (Throwable throwable) {
                            throw (RuntimeException)throwable;
                        }
                    }
                };
            }
            catch (ReflectiveOperationException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    private static interface Factory {
        public Encoder urlEncoderNoPadding();

        public Encoder encoder();

        public Decoder decoder();
    }

    public static interface Decoder {
        public byte[] decode(String var1);
    }

    public static interface Encoder {
        public String encodeToString(byte[] var1);
    }
}

