/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class CopyOnWriteMap<K, V>
implements ConcurrentMap<K, V> {
    private volatile Map<K, V> map;

    public CopyOnWriteMap() {
        this.map = Collections.emptyMap();
    }

    public CopyOnWriteMap(Map<K, V> map) {
        this.map = Collections.unmodifiableMap(map);
    }

    @Override
    public boolean containsKey(Object k2) {
        return this.map.containsKey(k2);
    }

    @Override
    public boolean containsValue(Object v) {
        return this.map.containsValue(v);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public V get(Object k2) {
        return this.map.get(k2);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public synchronized void clear() {
        this.map = Collections.emptyMap();
    }

    @Override
    public synchronized V put(K k2, V v) {
        HashMap<K, V> copy = new HashMap<K, V>(this.map);
        V prev = copy.put(k2, v);
        this.map = Collections.unmodifiableMap(copy);
        return prev;
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> entries) {
        HashMap<? extends K, ? extends V> copy = new HashMap<K, V>(this.map);
        copy.putAll(entries);
        this.map = Collections.unmodifiableMap(copy);
    }

    @Override
    public synchronized V remove(Object key) {
        HashMap<K, V> copy = new HashMap<K, V>(this.map);
        Object prev = copy.remove(key);
        this.map = Collections.unmodifiableMap(copy);
        return prev;
    }

    @Override
    public synchronized V putIfAbsent(K k2, V v) {
        if (!this.containsKey(k2)) {
            return this.put(k2, v);
        }
        return this.get(k2);
    }

    @Override
    public synchronized boolean remove(Object k2, Object v) {
        if (this.containsKey(k2) && this.get(k2).equals(v)) {
            this.remove(k2);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean replace(K k2, V original, V replacement) {
        if (this.containsKey(k2) && this.get(k2).equals(original)) {
            this.put(k2, replacement);
            return true;
        }
        return false;
    }

    @Override
    public synchronized V replace(K k2, V v) {
        if (this.containsKey(k2)) {
            return this.put(k2, v);
        }
        return null;
    }
}

