/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;

public abstract class LogXF {
    protected static final Level TRACE = new Level(5000, "TRACE", 7);
    private static final String FQCN = LogXF.class.getName();

    protected LogXF() {
    }

    protected static Boolean valueOf(boolean b2) {
        if (b2) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected static Character valueOf(char c2) {
        return new Character(c2);
    }

    protected static Byte valueOf(byte b2) {
        return new Byte(b2);
    }

    protected static Short valueOf(short b2) {
        return new Short(b2);
    }

    protected static Integer valueOf(int b2) {
        return new Integer(b2);
    }

    protected static Long valueOf(long b2) {
        return new Long(b2);
    }

    protected static Float valueOf(float b2) {
        return new Float(b2);
    }

    protected static Double valueOf(double b2) {
        return new Double(b2);
    }

    protected static Object[] toArray(Object param1) {
        return new Object[]{param1};
    }

    protected static Object[] toArray(Object param1, Object param2) {
        return new Object[]{param1, param2};
    }

    protected static Object[] toArray(Object param1, Object param2, Object param3) {
        return new Object[]{param1, param2, param3};
    }

    protected static Object[] toArray(Object param1, Object param2, Object param3, Object param4) {
        return new Object[]{param1, param2, param3, param4};
    }

    public static void entering(Logger logger2, String sourceClass, String sourceMethod) {
        if (logger2.isDebugEnabled()) {
            logger2.callAppenders(new LoggingEvent(FQCN, logger2, Level.DEBUG, sourceClass + "." + sourceMethod + " ENTRY", null));
        }
    }

    public static void entering(Logger logger2, String sourceClass, String sourceMethod, String param) {
        if (logger2.isDebugEnabled()) {
            String msg = sourceClass + "." + sourceMethod + " ENTRY " + param;
            logger2.callAppenders(new LoggingEvent(FQCN, logger2, Level.DEBUG, msg, null));
        }
    }

    public static void entering(Logger logger2, String sourceClass, String sourceMethod, Object param) {
        if (logger2.isDebugEnabled()) {
            String msg = sourceClass + "." + sourceMethod + " ENTRY ";
            if (param == null) {
                msg = msg + "null";
            } else {
                try {
                    msg = msg + param;
                }
                catch (Throwable ex) {
                    msg = msg + "?";
                }
            }
            logger2.callAppenders(new LoggingEvent(FQCN, logger2, Level.DEBUG, msg, null));
        }
    }

    public static void entering(Logger logger2, String sourceClass, String sourceMethod, Object[] params) {
        if (logger2.isDebugEnabled()) {
            String msg = sourceClass + "." + sourceMethod + " ENTRY ";
            if (params != null && params.length > 0) {
                String delim = "{";
                for (int i2 = 0; i2 < params.length; ++i2) {
                    try {
                        msg = msg + delim + params[i2];
                    }
                    catch (Throwable ex) {
                        msg = msg + delim + "?";
                    }
                    delim = ",";
                }
                msg = msg + "}";
            } else {
                msg = msg + "{}";
            }
            logger2.callAppenders(new LoggingEvent(FQCN, logger2, Level.DEBUG, msg, null));
        }
    }

    public static void exiting(Logger logger2, String sourceClass, String sourceMethod) {
        if (logger2.isDebugEnabled()) {
            logger2.callAppenders(new LoggingEvent(FQCN, logger2, Level.DEBUG, sourceClass + "." + sourceMethod + " RETURN", null));
        }
    }

    public static void exiting(Logger logger2, String sourceClass, String sourceMethod, String result) {
        if (logger2.isDebugEnabled()) {
            logger2.callAppenders(new LoggingEvent(FQCN, logger2, Level.DEBUG, sourceClass + "." + sourceMethod + " RETURN " + result, null));
        }
    }

    public static void exiting(Logger logger2, String sourceClass, String sourceMethod, Object result) {
        if (logger2.isDebugEnabled()) {
            String msg = sourceClass + "." + sourceMethod + " RETURN ";
            if (result == null) {
                msg = msg + "null";
            } else {
                try {
                    msg = msg + result;
                }
                catch (Throwable ex) {
                    msg = msg + "?";
                }
            }
            logger2.callAppenders(new LoggingEvent(FQCN, logger2, Level.DEBUG, msg, null));
        }
    }

    public static void throwing(Logger logger2, String sourceClass, String sourceMethod, Throwable thrown) {
        if (logger2.isDebugEnabled()) {
            logger2.callAppenders(new LoggingEvent(FQCN, logger2, Level.DEBUG, sourceClass + "." + sourceMethod + " THROW", thrown));
        }
    }
}

