/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Appender;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.LoggingEvent;

public class AppenderAttachableImpl
implements AppenderAttachable {
    protected Vector appenderList;

    public void addAppender(Appender newAppender) {
        if (newAppender == null) {
            return;
        }
        if (this.appenderList == null) {
            this.appenderList = new Vector(1);
        }
        if (!this.appenderList.contains(newAppender)) {
            this.appenderList.addElement(newAppender);
        }
    }

    public int appendLoopOnAppenders(LoggingEvent event) {
        int size = 0;
        if (this.appenderList != null) {
            size = this.appenderList.size();
            for (int i2 = 0; i2 < size; ++i2) {
                Appender appender = (Appender)this.appenderList.elementAt(i2);
                appender.doAppend(event);
            }
        }
        return size;
    }

    public Enumeration getAllAppenders() {
        if (this.appenderList == null) {
            return null;
        }
        return this.appenderList.elements();
    }

    public Appender getAppender(String name) {
        if (this.appenderList == null || name == null) {
            return null;
        }
        int size = this.appenderList.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Appender appender = (Appender)this.appenderList.elementAt(i2);
            if (!name.equals(appender.getName())) continue;
            return appender;
        }
        return null;
    }

    public boolean isAttached(Appender appender) {
        if (this.appenderList == null || appender == null) {
            return false;
        }
        int size = this.appenderList.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Appender a2 = (Appender)this.appenderList.elementAt(i2);
            if (a2 != appender) continue;
            return true;
        }
        return false;
    }

    public void removeAllAppenders() {
        if (this.appenderList != null) {
            int len = this.appenderList.size();
            for (int i2 = 0; i2 < len; ++i2) {
                Appender a2 = (Appender)this.appenderList.elementAt(i2);
                a2.close();
            }
            this.appenderList.removeAllElements();
            this.appenderList = null;
        }
    }

    public void removeAppender(Appender appender) {
        if (appender == null || this.appenderList == null) {
            return;
        }
        this.appenderList.removeElement(appender);
    }

    public void removeAppender(String name) {
        if (name == null || this.appenderList == null) {
            return;
        }
        int size = this.appenderList.size();
        for (int i2 = 0; i2 < size; ++i2) {
            if (!name.equals(((Appender)this.appenderList.elementAt(i2)).getName())) continue;
            this.appenderList.removeElementAt(i2);
            break;
        }
    }
}

