/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.zookeeper.Version;
import org.slf4j.Logger;

public class Environment {
    public static final String JAAS_CONF_KEY = "java.security.auth.login.config";

    private static void put(ArrayList<Entry> l2, String k2, String v) {
        l2.add(new Entry(k2, v));
    }

    public static List<Entry> list() {
        ArrayList<Entry> l2 = new ArrayList<Entry>();
        Environment.put(l2, "zookeeper.version", Version.getFullVersion());
        try {
            Environment.put(l2, "host.name", InetAddress.getLocalHost().getCanonicalHostName());
        }
        catch (UnknownHostException e2) {
            Environment.put(l2, "host.name", "<NA>");
        }
        Environment.put(l2, "java.version", System.getProperty("java.version", "<NA>"));
        Environment.put(l2, "java.vendor", System.getProperty("java.vendor", "<NA>"));
        Environment.put(l2, "java.home", System.getProperty("java.home", "<NA>"));
        Environment.put(l2, "java.class.path", System.getProperty("java.class.path", "<NA>"));
        Environment.put(l2, "java.library.path", System.getProperty("java.library.path", "<NA>"));
        Environment.put(l2, "java.io.tmpdir", System.getProperty("java.io.tmpdir", "<NA>"));
        Environment.put(l2, "java.compiler", System.getProperty("java.compiler", "<NA>"));
        Environment.put(l2, "os.name", System.getProperty("os.name", "<NA>"));
        Environment.put(l2, "os.arch", System.getProperty("os.arch", "<NA>"));
        Environment.put(l2, "os.version", System.getProperty("os.version", "<NA>"));
        Environment.put(l2, "user.name", System.getProperty("user.name", "<NA>"));
        Environment.put(l2, "user.home", System.getProperty("user.home", "<NA>"));
        Environment.put(l2, "user.dir", System.getProperty("user.dir", "<NA>"));
        Runtime runtime = Runtime.getRuntime();
        int mb = 0x100000;
        Environment.put(l2, "os.memory.free", Long.toString(runtime.freeMemory() / (long)mb) + "MB");
        Environment.put(l2, "os.memory.max", Long.toString(runtime.maxMemory() / (long)mb) + "MB");
        Environment.put(l2, "os.memory.total", Long.toString(runtime.totalMemory() / (long)mb) + "MB");
        return l2;
    }

    public static void logEnv(String msg, Logger log) {
        List<Entry> env = Environment.list();
        for (Entry e2 : env) {
            log.info(msg + e2.toString());
        }
    }

    public static class Entry {
        private String k;
        private String v;

        public Entry(String k2, String v) {
            this.k = k2;
            this.v = v;
        }

        public String getKey() {
            return this.k;
        }

        public String getValue() {
            return this.v;
        }

        public String toString() {
            return this.k + "=" + this.v;
        }
    }
}

