/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import org.apache.zookeeper.data.Stat;

public abstract class OpResult {
    private int type;

    private OpResult(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public static class ErrorResult
    extends OpResult {
        private int err;

        public ErrorResult(int err) {
            super(-1);
            this.err = err;
        }

        public int getErr() {
            return this.err;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof ErrorResult)) {
                return false;
            }
            ErrorResult other = (ErrorResult)o2;
            return this.getType() == other.getType() && this.err == other.getErr();
        }

        public int hashCode() {
            return this.getType() * 35 + this.err;
        }
    }

    public static class CheckResult
    extends OpResult {
        public CheckResult() {
            super(13);
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof CheckResult)) {
                return false;
            }
            CheckResult other = (CheckResult)o2;
            return this.getType() == other.getType();
        }

        public int hashCode() {
            return this.getType();
        }
    }

    public static class SetDataResult
    extends OpResult {
        private Stat stat;

        public SetDataResult(Stat stat) {
            super(5);
            this.stat = stat;
        }

        public Stat getStat() {
            return this.stat;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof SetDataResult)) {
                return false;
            }
            SetDataResult other = (SetDataResult)o2;
            return this.getType() == other.getType() && this.stat.getMzxid() == other.stat.getMzxid();
        }

        public int hashCode() {
            return (int)((long)(this.getType() * 35) + this.stat.getMzxid());
        }
    }

    public static class DeleteResult
    extends OpResult {
        public DeleteResult() {
            super(2);
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof DeleteResult)) {
                return false;
            }
            DeleteResult opResult = (DeleteResult)o2;
            return this.getType() == opResult.getType();
        }

        public int hashCode() {
            return this.getType();
        }
    }

    public static class CreateResult
    extends OpResult {
        private String path;
        private Stat stat;

        public CreateResult(String path) {
            this(1, path, null);
        }

        public CreateResult(String path, Stat stat) {
            this(15, path, stat);
        }

        private CreateResult(int opcode, String path, Stat stat) {
            super(opcode);
            this.path = path;
            this.stat = stat;
        }

        public String getPath() {
            return this.path;
        }

        public Stat getStat() {
            return this.stat;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof CreateResult)) {
                return false;
            }
            CreateResult other = (CreateResult)o2;
            boolean statsAreEqual = this.stat == null && other.stat == null || this.stat != null && other.stat != null && this.stat.getMzxid() == other.stat.getMzxid();
            return this.getType() == other.getType() && this.path.equals(other.getPath()) && statsAreEqual;
        }

        public int hashCode() {
            return (int)((long)(this.getType() * 35 + this.path.hashCode()) + (this.stat == null ? 0L : this.stat.getMzxid()));
        }
    }
}

