/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.cli;

import java.util.ArrayList;
import java.util.List;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;

public class AclParser {
    public static List<ACL> parse(String aclString) {
        String[] acls = aclString.split(",");
        ArrayList<ACL> acl = new ArrayList<ACL>();
        for (String a2 : acls) {
            int firstColon = a2.indexOf(58);
            int lastColon = a2.lastIndexOf(58);
            if (firstColon == -1 || lastColon == -1 || firstColon == lastColon) {
                System.err.println(a2 + " does not have the form scheme:id:perm");
                continue;
            }
            ACL newAcl = new ACL();
            newAcl.setId(new Id(a2.substring(0, firstColon), a2.substring(firstColon + 1, lastColon)));
            newAcl.setPerms(AclParser.getPermFromString(a2.substring(lastColon + 1)));
            acl.add(newAcl);
        }
        return acl;
    }

    private static int getPermFromString(String permString) {
        int perm = 0;
        block7: for (int i2 = 0; i2 < permString.length(); ++i2) {
            switch (permString.charAt(i2)) {
                case 'r': {
                    perm |= 1;
                    continue block7;
                }
                case 'w': {
                    perm |= 2;
                    continue block7;
                }
                case 'c': {
                    perm |= 4;
                    continue block7;
                }
                case 'd': {
                    perm |= 8;
                    continue block7;
                }
                case 'a': {
                    perm |= 0x10;
                    continue block7;
                }
                default: {
                    System.err.println("Unknown perm type: " + permString.charAt(i2));
                }
            }
        }
        return perm;
    }
}

