/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.cli;

import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.cli.CliCommand;
import org.apache.zookeeper.cli.CliException;
import org.apache.zookeeper.cli.CliParseException;
import org.apache.zookeeper.cli.CliWrapperException;
import org.apache.zookeeper.cli.StatPrinter;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public class GetAclCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public GetAclCommand() {
        super("getAcl", "[-s] path");
        options.addOption("s", false, "stats");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        PosixParser parser = new PosixParser();
        try {
            this.cl = parser.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = this.cl.getArgs();
        if (this.args.length < 2) {
            throw new CliParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        List<ACL> acl;
        String path = this.args[1];
        Stat stat = new Stat();
        try {
            acl = this.zk.getACL(path, stat);
        }
        catch (InterruptedException | KeeperException ex) {
            throw new CliWrapperException(ex);
        }
        for (ACL a2 : acl) {
            this.out.println(a2.getId() + ": " + GetAclCommand.getPermString(a2.getPerms()));
        }
        if (this.cl.hasOption("s")) {
            new StatPrinter(this.out).print(stat);
        }
        return false;
    }

    private static String getPermString(int perms) {
        StringBuilder p2 = new StringBuilder();
        if ((perms & 4) != 0) {
            p2.append('c');
        }
        if ((perms & 8) != 0) {
            p2.append('d');
        }
        if ((perms & 1) != 0) {
            p2.append('r');
        }
        if ((perms & 2) != 0) {
            p2.append('w');
        }
        if ((perms & 0x10) != 0) {
            p2.append('a');
        }
        return p2.toString();
    }
}

