/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.Record;

public class ByteBufferInputStream
extends InputStream {
    ByteBuffer bb;

    public ByteBufferInputStream(ByteBuffer bb) {
        this.bb = bb;
    }

    @Override
    public int read() throws IOException {
        if (this.bb.remaining() == 0) {
            return -1;
        }
        return this.bb.get() & 0xFF;
    }

    @Override
    public int available() throws IOException {
        return this.bb.remaining();
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        if (this.bb.remaining() == 0) {
            return -1;
        }
        if (len > this.bb.remaining()) {
            len = this.bb.remaining();
        }
        this.bb.get(b2, off, len);
        return len;
    }

    @Override
    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    @Override
    public long skip(long n2) throws IOException {
        if (n2 < 0L) {
            return 0L;
        }
        n2 = Math.min(n2, (long)this.bb.remaining());
        this.bb.position(this.bb.position() + (int)n2);
        return n2;
    }

    public static void byteBuffer2Record(ByteBuffer bb, Record record) throws IOException {
        BinaryInputArchive ia = BinaryInputArchive.getArchive(new ByteBufferInputStream(bb));
        record.deserialize(ia, "request");
    }
}

