/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.server.persistence.TxnLog;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.server.quorum.QuorumPacket;
import org.apache.zookeeper.txn.TxnHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxnLogProposalIterator
implements Iterator<Leader.Proposal> {
    private static final Logger LOG = LoggerFactory.getLogger(TxnLogProposalIterator.class);
    public static final TxnLogProposalIterator EMPTY_ITERATOR = new TxnLogProposalIterator();
    private boolean hasNext = false;
    private TxnLog.TxnIterator itr;

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public Leader.Proposal next() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive(baos);
        Leader.Proposal p2 = new Leader.Proposal();
        try {
            QuorumPacket pp;
            TxnHeader hdr = this.itr.getHeader();
            Record txn = this.itr.getTxn();
            hdr.serialize(boa, "hdr");
            if (txn != null) {
                txn.serialize(boa, "txn");
            }
            baos.close();
            p2.packet = pp = new QuorumPacket(2, this.itr.getHeader().getZxid(), baos.toByteArray(), null);
            p2.request = null;
            this.hasNext = this.itr.next();
        }
        catch (IOException e2) {
            LOG.error("Unable to read txnlog from disk", e2);
            this.hasNext = false;
        }
        return p2;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        if (this.itr != null) {
            try {
                this.itr.close();
            }
            catch (IOException ioe) {
                LOG.warn("Error closing file iterator", ioe);
            }
        }
    }

    private TxnLogProposalIterator() {
    }

    public TxnLogProposalIterator(TxnLog.TxnIterator itr) {
        if (itr != null) {
            this.itr = itr;
            this.hasNext = itr.getHeader() != null;
        }
    }
}

