/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WatchesReport {
    private final Map<Long, Set<String>> id2paths;

    WatchesReport(Map<Long, Set<String>> id2paths) {
        this.id2paths = Collections.unmodifiableMap(WatchesReport.deepCopy(id2paths));
    }

    private static Map<Long, Set<String>> deepCopy(Map<Long, Set<String>> m2) {
        HashMap<Long, Set<String>> m22 = new HashMap<Long, Set<String>>();
        for (Map.Entry<Long, Set<String>> e2 : m2.entrySet()) {
            m22.put(e2.getKey(), new HashSet(e2.getValue()));
        }
        return m22;
    }

    public boolean hasPaths(long sessionId) {
        return this.id2paths.containsKey(sessionId);
    }

    public Set<String> getPaths(long sessionId) {
        Set<String> s2 = this.id2paths.get(sessionId);
        return s2 != null ? Collections.unmodifiableSet(s2) : null;
    }

    public Map<Long, Set<String>> toMap() {
        return WatchesReport.deepCopy(this.id2paths);
    }
}

