/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.admin;

import java.lang.reflect.InvocationTargetException;
import org.apache.zookeeper.server.admin.AdminServer;
import org.apache.zookeeper.server.admin.DummyAdminServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminServerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AdminServerFactory.class);

    public static AdminServer createAdminServer() {
        if (!"false".equals(System.getProperty("zookeeper.admin.enableServer"))) {
            try {
                Class<?> jettyAdminServerC = Class.forName("org.apache.zookeeper.server.admin.JettyAdminServer");
                Object adminServer = jettyAdminServerC.getConstructor(new Class[0]).newInstance(new Object[0]);
                return (AdminServer)adminServer;
            }
            catch (ClassNotFoundException e2) {
                LOG.warn("Unable to start JettyAdminServer", e2);
            }
            catch (InstantiationException e3) {
                LOG.warn("Unable to start JettyAdminServer", e3);
            }
            catch (IllegalAccessException e4) {
                LOG.warn("Unable to start JettyAdminServer", e4);
            }
            catch (InvocationTargetException e5) {
                LOG.warn("Unable to start JettyAdminServer", e5);
            }
            catch (NoSuchMethodException e6) {
                LOG.warn("Unable to start JettyAdminServer", e6);
            }
            catch (NoClassDefFoundError e7) {
                LOG.warn("Unable to load jetty, not starting JettyAdminServer", e7);
            }
        }
        return new DummyAdminServer();
    }
}

