/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.auth;

import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.auth.AuthenticationProvider;
import org.apache.zookeeper.server.auth.KerberosName;

public class SASLAuthenticationProvider
implements AuthenticationProvider {
    @Override
    public String getScheme() {
        return "sasl";
    }

    @Override
    public KeeperException.Code handleAuthentication(ServerCnxn cnxn, byte[] authData) {
        return KeeperException.Code.AUTHFAILED;
    }

    @Override
    public boolean matches(String id, String aclExpr) {
        if (System.getProperty("zookeeper.superUser") != null && (id.equals(System.getProperty("zookeeper.superUser")) || id.equals(aclExpr))) {
            return true;
        }
        if (id.equals("super") || id.equals(aclExpr)) {
            return true;
        }
        String readAccessUser = System.getProperty("zookeeper.letAnySaslUserDoX");
        return readAccessUser != null && aclExpr.equals(readAccessUser);
    }

    @Override
    public boolean isAuthenticated() {
        return true;
    }

    @Override
    public boolean isValid(String id) {
        try {
            new KerberosName(id);
            return true;
        }
        catch (IllegalArgumentException e2) {
            return false;
        }
    }
}

