/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.common.AtomicFileWritingIdiom;
import org.apache.zookeeper.common.Time;
import org.apache.zookeeper.jmx.MBeanRegistry;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.ZooKeeperThread;
import org.apache.zookeeper.server.admin.AdminServer;
import org.apache.zookeeper.server.admin.AdminServerFactory;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.AuthFastLeaderElection;
import org.apache.zookeeper.server.quorum.Election;
import org.apache.zookeeper.server.quorum.FastLeaderElection;
import org.apache.zookeeper.server.quorum.Follower;
import org.apache.zookeeper.server.quorum.FollowerZooKeeperServer;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.server.quorum.LeaderElection;
import org.apache.zookeeper.server.quorum.LeaderElectionBean;
import org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import org.apache.zookeeper.server.quorum.LearnerHandler;
import org.apache.zookeeper.server.quorum.LocalPeerBean;
import org.apache.zookeeper.server.quorum.Observer;
import org.apache.zookeeper.server.quorum.ObserverZooKeeperServer;
import org.apache.zookeeper.server.quorum.QuorumBean;
import org.apache.zookeeper.server.quorum.QuorumCnxManager;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.quorum.QuorumStats;
import org.apache.zookeeper.server.quorum.ReadOnlyZooKeeperServer;
import org.apache.zookeeper.server.quorum.RemotePeerBean;
import org.apache.zookeeper.server.quorum.Vote;
import org.apache.zookeeper.server.quorum.flexible.QuorumMaj;
import org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import org.apache.zookeeper.server.util.ZxidUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuorumPeer
extends ZooKeeperThread
implements QuorumStats.Provider {
    private static final Logger LOG = LoggerFactory.getLogger(QuorumPeer.class);
    private QuorumBean jmxQuorumBean;
    LocalPeerBean jmxLocalPeerBean;
    private Map<Long, RemotePeerBean> jmxRemotePeerBean;
    LeaderElectionBean jmxLeaderElectionBean;
    private QuorumCnxManager qcm;
    private ZKDatabase zkDb;
    static final long OBSERVER_ID = Long.MAX_VALUE;
    public long start_fle;
    public long end_fle;
    public static final String FLE_TIME_UNIT = "MS";
    private LearnerType learnerType = LearnerType.PARTICIPANT;
    private String configFilename = null;
    public QuorumVerifier quorumVerifier;
    public QuorumVerifier lastSeenQuorumVerifier = null;
    final Object QV_LOCK = new Object();
    private long myid;
    private volatile Vote currentVote;
    volatile boolean running = true;
    protected int tickTime;
    protected boolean localSessionsEnabled = false;
    protected boolean localSessionsUpgradingEnabled = true;
    protected int minSessionTimeout = -1;
    protected int maxSessionTimeout = -1;
    protected int initLimit;
    protected int syncLimit;
    protected boolean syncEnabled = true;
    protected AtomicInteger tick = new AtomicInteger();
    protected boolean quorumListenOnAllIPs = false;
    private long electionTimeTaken = -1L;
    private ServerState state = ServerState.LOOKING;
    private boolean reconfigFlag = false;
    DatagramSocket udpSocket;
    private InetSocketAddress myQuorumAddr;
    private InetSocketAddress myElectionAddr = null;
    private InetSocketAddress myClientAddr = null;
    private int electionType;
    Election electionAlg;
    ServerCnxnFactory cnxnFactory;
    ServerCnxnFactory secureCnxnFactory;
    private FileTxnSnapLog logFactory = null;
    private final QuorumStats quorumStats = new QuorumStats(this);
    AdminServer adminServer;
    ResponderThread responder;
    public Follower follower;
    public Leader leader;
    public Observer observer;
    boolean shuttingDownLE = false;
    public static final String SYNC_ENABLED = "zookeeper.observer.syncEnabled";
    private long acceptedEpoch = -1L;
    private long currentEpoch = -1L;
    public static final String CURRENT_EPOCH_FILENAME = "currentEpoch";
    public static final String ACCEPTED_EPOCH_FILENAME = "acceptedEpoch";

    public LearnerType getLearnerType() {
        return this.learnerType;
    }

    public void setLearnerType(LearnerType p2) {
        this.learnerType = p2;
    }

    protected synchronized void setConfigFileName(String s2) {
        this.configFilename = s2;
    }

    public int getQuorumSize() {
        return this.getVotingView().size();
    }

    @Override
    public long getId() {
        return this.myid;
    }

    public synchronized Vote getCurrentVote() {
        return this.currentVote;
    }

    public synchronized void setCurrentVote(Vote v) {
        this.currentVote = v;
    }

    public synchronized void setPeerState(ServerState newState) {
        this.state = newState;
    }

    public synchronized void reconfigFlagSet() {
        this.reconfigFlag = true;
    }

    public synchronized void reconfigFlagClear() {
        this.reconfigFlag = false;
    }

    public synchronized boolean isReconfigStateChange() {
        return this.reconfigFlag;
    }

    public synchronized ServerState getPeerState() {
        return this.state;
    }

    public void recreateSocketAddresses(long id) {
        QuorumServer qs;
        QuorumVerifier qv = this.getQuorumVerifier();
        if (qv != null && (qs = qv.getAllMembers().get(id)) != null) {
            qs.recreateSocketAddresses();
            if (id == this.getId()) {
                this.setQuorumAddress(qs.addr);
                this.setElectionAddress(qs.electionAddr);
            }
        }
        if ((qv = this.getLastSeenQuorumVerifier()) != null && (qs = qv.getAllMembers().get(id)) != null) {
            qs.recreateSocketAddresses();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetSocketAddress getQuorumAddress() {
        Object object = this.QV_LOCK;
        synchronized (object) {
            return this.myQuorumAddr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQuorumAddress(InetSocketAddress addr) {
        Object object = this.QV_LOCK;
        synchronized (object) {
            this.myQuorumAddr = addr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetSocketAddress getElectionAddress() {
        Object object = this.QV_LOCK;
        synchronized (object) {
            return this.myElectionAddr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setElectionAddress(InetSocketAddress addr) {
        Object object = this.QV_LOCK;
        synchronized (object) {
            this.myElectionAddr = addr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetSocketAddress getClientAddress() {
        Object object = this.QV_LOCK;
        synchronized (object) {
            return this.myClientAddr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClientAddress(InetSocketAddress addr) {
        Object object = this.QV_LOCK;
        synchronized (object) {
            this.myClientAddr = addr;
        }
    }

    public QuorumPeer() {
        super("QuorumPeer");
        this.jmxRemotePeerBean = new HashMap<Long, RemotePeerBean>();
        this.adminServer = AdminServerFactory.createAdminServer();
    }

    public QuorumPeer(Map<Long, QuorumServer> quorumPeers, File dataDir, File dataLogDir, int electionType, long myid, int tickTime, int initLimit, int syncLimit, ServerCnxnFactory cnxnFactory) throws IOException {
        this(quorumPeers, dataDir, dataLogDir, electionType, myid, tickTime, initLimit, syncLimit, false, cnxnFactory, new QuorumMaj(quorumPeers));
    }

    public QuorumPeer(Map<Long, QuorumServer> quorumPeers, File dataDir, File dataLogDir, int electionType, long myid, int tickTime, int initLimit, int syncLimit, boolean quorumListenOnAllIPs, ServerCnxnFactory cnxnFactory, QuorumVerifier quorumConfig) throws IOException {
        this();
        this.cnxnFactory = cnxnFactory;
        this.electionType = electionType;
        this.myid = myid;
        this.tickTime = tickTime;
        this.initLimit = initLimit;
        this.syncLimit = syncLimit;
        this.quorumListenOnAllIPs = quorumListenOnAllIPs;
        this.logFactory = new FileTxnSnapLog(dataLogDir, dataDir);
        this.zkDb = new ZKDatabase(this.logFactory);
        if (quorumConfig == null) {
            quorumConfig = new QuorumMaj(quorumPeers);
        }
        this.setQuorumVerifier(quorumConfig, false);
        this.adminServer = AdminServerFactory.createAdminServer();
    }

    QuorumStats quorumStats() {
        return this.quorumStats;
    }

    @Override
    public synchronized void start() {
        if (!this.getView().containsKey(this.myid)) {
            throw new RuntimeException("My id " + this.myid + " not in the peer list");
        }
        this.loadDataBase();
        this.startServerCnxnFactory();
        try {
            this.adminServer.start();
        }
        catch (AdminServer.AdminServerException e2) {
            LOG.warn("Problem starting AdminServer", e2);
            System.out.println(e2);
        }
        this.startLeaderElection();
        super.start();
    }

    private void loadDataBase() {
        try {
            this.zkDb.loadDataBase();
            long lastProcessedZxid = this.zkDb.getDataTree().lastProcessedZxid;
            long epochOfZxid = ZxidUtils.getEpochFromZxid(lastProcessedZxid);
            try {
                this.currentEpoch = this.readLongFromFile(CURRENT_EPOCH_FILENAME);
            }
            catch (FileNotFoundException e2) {
                this.currentEpoch = epochOfZxid;
                LOG.info("currentEpoch not found! Creating with a reasonable default of {}. This should only happen when you are upgrading your installation", (Object)this.currentEpoch);
                this.writeLongToFile(CURRENT_EPOCH_FILENAME, this.currentEpoch);
            }
            if (epochOfZxid > this.currentEpoch) {
                throw new IOException("The current epoch, " + ZxidUtils.zxidToString(this.currentEpoch) + ", is older than the last zxid, " + lastProcessedZxid);
            }
            try {
                this.acceptedEpoch = this.readLongFromFile(ACCEPTED_EPOCH_FILENAME);
            }
            catch (FileNotFoundException e3) {
                this.acceptedEpoch = epochOfZxid;
                LOG.info("acceptedEpoch not found! Creating with a reasonable default of {}. This should only happen when you are upgrading your installation", (Object)this.acceptedEpoch);
                this.writeLongToFile(ACCEPTED_EPOCH_FILENAME, this.acceptedEpoch);
            }
            if (this.acceptedEpoch < this.currentEpoch) {
                throw new IOException("The accepted epoch, " + ZxidUtils.zxidToString(this.acceptedEpoch) + " is less than the current epoch, " + ZxidUtils.zxidToString(this.currentEpoch));
            }
        }
        catch (IOException ie) {
            LOG.error("Unable to load database on disk", ie);
            throw new RuntimeException("Unable to run quorum server ", ie);
        }
    }

    public synchronized void stopLeaderElection() {
        this.responder.running = false;
        this.responder.interrupt();
    }

    public synchronized void startLeaderElection() {
        try {
            if (this.getPeerState() == ServerState.LOOKING) {
                this.currentVote = new Vote(this.myid, this.getLastLoggedZxid(), this.getCurrentEpoch());
            }
        }
        catch (IOException e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        if (this.electionType == 0) {
            try {
                this.udpSocket = new DatagramSocket(this.myQuorumAddr.getPort());
                this.responder = new ResponderThread();
                this.responder.start();
            }
            catch (SocketException e3) {
                throw new RuntimeException(e3);
            }
        }
        this.electionAlg = this.createElectionAlgorithm(this.electionType);
    }

    protected static int countParticipants(Map<Long, QuorumServer> peers) {
        int count = 0;
        for (QuorumServer q2 : peers.values()) {
            if (q2.type != LearnerType.PARTICIPANT) continue;
            ++count;
        }
        return count;
    }

    public QuorumPeer(Map<Long, QuorumServer> quorumPeers, File snapDir, File logDir, int clientPort, int electionAlg, long myid, int tickTime, int initLimit, int syncLimit) throws IOException {
        this(quorumPeers, snapDir, logDir, electionAlg, myid, tickTime, initLimit, syncLimit, false, ServerCnxnFactory.createFactory(QuorumPeer.getClientAddress(quorumPeers, myid, clientPort), -1), new QuorumMaj(quorumPeers));
    }

    public QuorumPeer(Map<Long, QuorumServer> quorumPeers, File snapDir, File logDir, int clientPort, int electionAlg, long myid, int tickTime, int initLimit, int syncLimit, QuorumVerifier quorumConfig) throws IOException {
        this(quorumPeers, snapDir, logDir, electionAlg, myid, tickTime, initLimit, syncLimit, false, ServerCnxnFactory.createFactory(QuorumPeer.getClientAddress(quorumPeers, myid, clientPort), -1), quorumConfig);
    }

    private static InetSocketAddress getClientAddress(Map<Long, QuorumServer> quorumPeers, long myid, int clientPort) throws IOException {
        QuorumServer quorumServer = quorumPeers.get(myid);
        if (null == quorumServer) {
            throw new IOException("No QuorumServer correspoding to myid " + myid);
        }
        if (null == quorumServer.clientAddr) {
            return new InetSocketAddress(clientPort);
        }
        if (quorumServer.clientAddr.getPort() != clientPort) {
            throw new IOException("QuorumServer port " + quorumServer.clientAddr.getPort() + " does not match with given port " + clientPort);
        }
        return quorumServer.clientAddr;
    }

    public long getLastLoggedZxid() {
        if (!this.zkDb.isInitialized()) {
            this.loadDataBase();
        }
        return this.zkDb.getDataTreeLastProcessedZxid();
    }

    protected Follower makeFollower(FileTxnSnapLog logFactory) throws IOException {
        return new Follower(this, new FollowerZooKeeperServer(logFactory, this, this.zkDb));
    }

    protected Leader makeLeader(FileTxnSnapLog logFactory) throws IOException {
        return new Leader(this, new LeaderZooKeeperServer(logFactory, this, this.zkDb));
    }

    protected Observer makeObserver(FileTxnSnapLog logFactory) throws IOException {
        return new Observer(this, new ObserverZooKeeperServer(logFactory, this, this.zkDb));
    }

    protected Election createElectionAlgorithm(int electionAlgorithm) {
        Election le = null;
        switch (electionAlgorithm) {
            case 0: {
                le = new LeaderElection(this);
                break;
            }
            case 1: {
                le = new AuthFastLeaderElection(this);
                break;
            }
            case 2: {
                le = new AuthFastLeaderElection(this, true);
                break;
            }
            case 3: {
                this.qcm = new QuorumCnxManager(this);
                QuorumCnxManager.Listener listener = this.qcm.listener;
                if (listener != null) {
                    listener.start();
                    FastLeaderElection fle = new FastLeaderElection(this, this.qcm);
                    fle.start();
                    le = fle;
                    break;
                }
                LOG.error("Null listener when initializing cnx manager");
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return le;
    }

    protected Election makeLEStrategy() {
        LOG.debug("Initializing leader election protocol...");
        if (this.getElectionType() == 0) {
            this.electionAlg = new LeaderElection(this);
        }
        return this.electionAlg;
    }

    protected synchronized void setLeader(Leader newLeader) {
        this.leader = newLeader;
    }

    protected synchronized void setFollower(Follower newFollower) {
        this.follower = newFollower;
    }

    protected synchronized void setObserver(Observer newObserver) {
        this.observer = newObserver;
    }

    public synchronized ZooKeeperServer getActiveServer() {
        if (this.leader != null) {
            return this.leader.zk;
        }
        if (this.follower != null) {
            return this.follower.zk;
        }
        if (this.observer != null) {
            return this.observer.zk;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.updateThreadName();
        LOG.debug("Starting quorum peer");
        try {
            this.jmxQuorumBean = new QuorumBean(this);
            MBeanRegistry.getInstance().register(this.jmxQuorumBean, null);
            for (QuorumServer s2 : this.getView().values()) {
                if (this.getId() == s2.id) {
                    LocalPeerBean p2 = this.jmxLocalPeerBean = new LocalPeerBean(this);
                    try {
                        MBeanRegistry.getInstance().register(p2, this.jmxQuorumBean);
                    }
                    catch (Exception e2) {
                        LOG.warn("Failed to register with JMX", e2);
                        this.jmxLocalPeerBean = null;
                    }
                    continue;
                }
                RemotePeerBean rBean = new RemotePeerBean(s2);
                try {
                    MBeanRegistry.getInstance().register(rBean, this.jmxQuorumBean);
                    this.jmxRemotePeerBean.put(s2.id, rBean);
                }
                catch (Exception e3) {
                    LOG.warn("Failed to register with JMX", e3);
                }
            }
        }
        catch (Exception e4) {
            LOG.warn("Failed to register with JMX", e4);
            this.jmxQuorumBean = null;
        }
        try {
            while (this.running) {
                switch (this.getPeerState()) {
                    case LOOKING: {
                        LOG.info("LOOKING");
                        if (Boolean.getBoolean("readonlymode.enabled")) {
                            LOG.info("Attempting to start ReadOnlyZooKeeperServer");
                            final ReadOnlyZooKeeperServer roZk = new ReadOnlyZooKeeperServer(this.logFactory, this, this.zkDb);
                            Thread roZkMgr = new Thread(){

                                @Override
                                public void run() {
                                    try {
                                        1.sleep(Math.max(2000, QuorumPeer.this.tickTime));
                                        if (ServerState.LOOKING.equals((Object)QuorumPeer.this.getPeerState())) {
                                            roZk.startup();
                                        }
                                    }
                                    catch (InterruptedException e2) {
                                        LOG.info("Interrupted while attempting to start ReadOnlyZooKeeperServer, not started");
                                    }
                                    catch (Exception e3) {
                                        LOG.error("FAILED to start ReadOnlyZooKeeperServer", e3);
                                    }
                                }
                            };
                            try {
                                roZkMgr.start();
                                this.reconfigFlagClear();
                                if (this.shuttingDownLE) {
                                    this.shuttingDownLE = false;
                                    this.startLeaderElection();
                                }
                                this.setCurrentVote(this.makeLEStrategy().lookForLeader());
                                break;
                            }
                            catch (Exception e5) {
                                LOG.warn("Unexpected exception", e5);
                                this.setPeerState(ServerState.LOOKING);
                                break;
                            }
                            finally {
                                roZkMgr.interrupt();
                                roZk.shutdown();
                            }
                        }
                        try {
                            this.reconfigFlagClear();
                            if (this.shuttingDownLE) {
                                this.shuttingDownLE = false;
                                this.startLeaderElection();
                            }
                            this.setCurrentVote(this.makeLEStrategy().lookForLeader());
                        }
                        catch (Exception e6) {
                            LOG.warn("Unexpected exception", e6);
                            this.setPeerState(ServerState.LOOKING);
                        }
                        break;
                    }
                    case OBSERVING: {
                        try {
                            LOG.info("OBSERVING");
                            this.setObserver(this.makeObserver(this.logFactory));
                            this.observer.observeLeader();
                            break;
                        }
                        catch (Exception e7) {
                            LOG.warn("Unexpected exception", e7);
                            break;
                        }
                        finally {
                            this.observer.shutdown();
                            this.setObserver(null);
                            this.updateServerState();
                        }
                    }
                    case FOLLOWING: {
                        try {
                            LOG.info("FOLLOWING");
                            this.setFollower(this.makeFollower(this.logFactory));
                            this.follower.followLeader();
                            break;
                        }
                        catch (Exception e8) {
                            LOG.warn("Unexpected exception", e8);
                            break;
                        }
                        finally {
                            this.follower.shutdown();
                            this.setFollower(null);
                            this.updateServerState();
                        }
                    }
                    case LEADING: {
                        LOG.info("LEADING");
                        try {
                            this.setLeader(this.makeLeader(this.logFactory));
                            this.leader.lead();
                            this.setLeader(null);
                            break;
                        }
                        catch (Exception e9) {
                            LOG.warn("Unexpected exception", e9);
                            break;
                        }
                        finally {
                            if (this.leader != null) {
                                this.leader.shutdown("Forcing shutdown");
                                this.setLeader(null);
                            }
                            this.updateServerState();
                        }
                    }
                }
                this.start_fle = Time.currentElapsedTime();
            }
        }
        finally {
            LOG.warn("QuorumPeer main thread exited");
            MBeanRegistry instance = MBeanRegistry.getInstance();
            instance.unregister(this.jmxQuorumBean);
            instance.unregister(this.jmxLocalPeerBean);
            for (RemotePeerBean remotePeerBean : this.jmxRemotePeerBean.values()) {
                instance.unregister(remotePeerBean);
            }
            this.jmxQuorumBean = null;
            this.jmxLocalPeerBean = null;
            this.jmxRemotePeerBean = null;
        }
    }

    private synchronized void updateServerState() {
        if (!this.reconfigFlag) {
            this.setPeerState(ServerState.LOOKING);
            LOG.warn("PeerState set to LOOKING");
            return;
        }
        if (this.getId() == this.getCurrentVote().getId()) {
            this.setPeerState(ServerState.LEADING);
            LOG.debug("PeerState set to LEADING");
        } else if (this.getLearnerType() == LearnerType.PARTICIPANT) {
            this.setPeerState(ServerState.FOLLOWING);
            LOG.debug("PeerState set to FOLLOWING");
        } else if (this.getLearnerType() == LearnerType.OBSERVER) {
            this.setPeerState(ServerState.OBSERVING);
            LOG.debug("PeerState set to OBSERVER");
        } else {
            this.setPeerState(ServerState.LOOKING);
            LOG.debug("Shouldn't be here");
        }
        this.reconfigFlag = false;
    }

    public void shutdown() {
        this.running = false;
        if (this.leader != null) {
            this.leader.shutdown("quorum Peer shutdown");
        }
        if (this.follower != null) {
            this.follower.shutdown();
        }
        this.shutdownServerCnxnFactory();
        if (this.udpSocket != null) {
            this.udpSocket.close();
        }
        try {
            this.adminServer.shutdown();
        }
        catch (AdminServer.AdminServerException e2) {
            LOG.warn("Problem stopping AdminServer", e2);
        }
        if (this.getElectionAlg() != null) {
            this.interrupt();
            this.getElectionAlg().shutdown();
        }
        try {
            this.zkDb.close();
        }
        catch (IOException ie) {
            LOG.warn("Error closing logs ", ie);
        }
    }

    public Map<Long, QuorumServer> getView() {
        return Collections.unmodifiableMap(this.getQuorumVerifier().getAllMembers());
    }

    public Map<Long, QuorumServer> getVotingView() {
        return this.getQuorumVerifier().getVotingMembers();
    }

    public Map<Long, QuorumServer> getObservingView() {
        return this.getQuorumVerifier().getObservingMembers();
    }

    public synchronized Set<Long> getCurrentAndNextConfigVoters() {
        HashSet<Long> voterIds = new HashSet<Long>(this.getQuorumVerifier().getVotingMembers().keySet());
        if (this.getLastSeenQuorumVerifier() != null) {
            voterIds.addAll(this.getLastSeenQuorumVerifier().getVotingMembers().keySet());
        }
        return voterIds;
    }

    public boolean viewContains(Long sid) {
        return this.getView().containsKey(sid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getQuorumPeers() {
        ArrayList<String> l2 = new ArrayList<String>();
        QuorumPeer quorumPeer = this;
        synchronized (quorumPeer) {
            if (this.leader != null) {
                for (LearnerHandler fh : this.leader.getLearners()) {
                    if (fh.getSocket() == null) continue;
                    String s2 = fh.getSocket().getRemoteSocketAddress().toString();
                    if (this.leader.isLearnerSynced(fh)) {
                        s2 = s2 + "*";
                    }
                    l2.add(s2);
                }
            } else if (this.follower != null) {
                l2.add(this.follower.sock.getRemoteSocketAddress().toString());
            }
        }
        return l2.toArray(new String[0]);
    }

    @Override
    public String getServerState() {
        switch (this.getPeerState()) {
            case LOOKING: {
                return "leaderelection";
            }
            case LEADING: {
                return "leading";
            }
            case FOLLOWING: {
                return "following";
            }
            case OBSERVING: {
                return "observing";
            }
        }
        return "unknown";
    }

    public void setMyid(long myid) {
        this.myid = myid;
    }

    public int getTickTime() {
        return this.tickTime;
    }

    public void setTickTime(int tickTime) {
        LOG.info("tickTime set to " + tickTime);
        this.tickTime = tickTime;
    }

    public int getMaxClientCnxnsPerHost() {
        if (this.cnxnFactory != null) {
            return this.cnxnFactory.getMaxClientCnxnsPerHost();
        }
        if (this.secureCnxnFactory != null) {
            return this.secureCnxnFactory.getMaxClientCnxnsPerHost();
        }
        return -1;
    }

    public boolean areLocalSessionsEnabled() {
        return this.localSessionsEnabled;
    }

    public void enableLocalSessions(boolean flag) {
        LOG.info("Local sessions " + (flag ? "enabled" : "disabled"));
        this.localSessionsEnabled = flag;
    }

    public boolean isLocalSessionsUpgradingEnabled() {
        return this.localSessionsUpgradingEnabled;
    }

    public void enableLocalSessionsUpgrading(boolean flag) {
        LOG.info("Local session upgrading " + (flag ? "enabled" : "disabled"));
        this.localSessionsUpgradingEnabled = flag;
    }

    public int getMinSessionTimeout() {
        return this.minSessionTimeout;
    }

    public void setMinSessionTimeout(int min) {
        LOG.info("minSessionTimeout set to " + min);
        this.minSessionTimeout = min;
    }

    public int getMaxSessionTimeout() {
        return this.maxSessionTimeout;
    }

    public void setMaxSessionTimeout(int max) {
        LOG.info("maxSessionTimeout set to " + max);
        this.maxSessionTimeout = max;
    }

    public int getInitLimit() {
        return this.initLimit;
    }

    public void setInitLimit(int initLimit) {
        LOG.info("initLimit set to " + initLimit);
        this.initLimit = initLimit;
    }

    public int getTick() {
        return this.tick.get();
    }

    public QuorumVerifier configFromString(String s2) throws IOException, QuorumPeerConfig.ConfigException {
        Properties props = new Properties();
        props.load(new StringReader(s2));
        return QuorumPeerConfig.parseDynamicConfig(props, this.electionType, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuorumVerifier getQuorumVerifier() {
        Object object = this.QV_LOCK;
        synchronized (object) {
            return this.quorumVerifier;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuorumVerifier getLastSeenQuorumVerifier() {
        Object object = this.QV_LOCK;
        synchronized (object) {
            return this.lastSeenQuorumVerifier;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectNewPeers() {
        Object object = this.QV_LOCK;
        synchronized (object) {
            if (this.qcm != null && this.quorumVerifier != null && this.lastSeenQuorumVerifier != null) {
                Map<Long, QuorumServer> committedView = this.quorumVerifier.getAllMembers();
                for (Map.Entry<Long, QuorumServer> e2 : this.lastSeenQuorumVerifier.getAllMembers().entrySet()) {
                    if (e2.getKey().longValue() == this.getId() || committedView.containsKey(e2.getKey())) continue;
                    this.qcm.connectOne(e2.getKey());
                }
            }
        }
    }

    public synchronized void restartLeaderElection(QuorumVerifier qvOLD, QuorumVerifier qvNEW) {
        if (qvOLD == null || !qvOLD.equals(qvNEW)) {
            LOG.warn("Restarting Leader Election");
            this.getElectionAlg().shutdown();
            this.shuttingDownLE = false;
            this.startLeaderElection();
        }
    }

    public String getNextDynamicConfigFilename() {
        return this.configFilename + ".dynamic.next";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastSeenQuorumVerifier(QuorumVerifier qv, boolean writeToDisk) {
        Object object = this.QV_LOCK;
        synchronized (object) {
            if (this.lastSeenQuorumVerifier != null && this.lastSeenQuorumVerifier.getVersion() > qv.getVersion()) {
                LOG.error("setLastSeenQuorumVerifier called with stale config " + qv.getVersion() + ". Current version: " + this.quorumVerifier.getVersion());
            }
            if (this.lastSeenQuorumVerifier != null && this.lastSeenQuorumVerifier.getVersion() == qv.getVersion()) {
                return;
            }
            this.lastSeenQuorumVerifier = qv;
            this.connectNewPeers();
            if (writeToDisk) {
                try {
                    QuorumPeerConfig.writeDynamicConfig(this.getNextDynamicConfigFilename(), qv, true);
                }
                catch (IOException e2) {
                    LOG.error("Error writing next dynamic config file to disk: ", (Object)e2.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuorumVerifier setQuorumVerifier(QuorumVerifier qv, boolean writeToDisk) {
        Object object = this.QV_LOCK;
        synchronized (object) {
            QuorumServer qs;
            if (this.quorumVerifier != null && this.quorumVerifier.getVersion() >= qv.getVersion()) {
                LOG.debug(this.getId() + " setQuorumVerifier called with known or old config " + qv.getVersion() + ". Current version: " + this.quorumVerifier.getVersion());
                return this.quorumVerifier;
            }
            QuorumVerifier prevQV = this.quorumVerifier;
            this.quorumVerifier = qv;
            if (this.lastSeenQuorumVerifier == null || qv.getVersion() > this.lastSeenQuorumVerifier.getVersion()) {
                this.lastSeenQuorumVerifier = qv;
            }
            if (writeToDisk) {
                if (this.configFilename != null) {
                    try {
                        String dynamicConfigFilename = this.makeDynamicConfigFilename(qv.getVersion());
                        QuorumPeerConfig.writeDynamicConfig(dynamicConfigFilename, qv, false);
                        QuorumPeerConfig.editStaticConfig(this.configFilename, dynamicConfigFilename, this.needEraseClientInfoFromStaticConfig());
                    }
                    catch (IOException e2) {
                        LOG.error("Error closing file: ", (Object)e2.getMessage());
                    }
                } else {
                    LOG.info("writeToDisk == true but configFilename == null");
                }
            }
            if (qv.getVersion() == this.lastSeenQuorumVerifier.getVersion()) {
                QuorumPeerConfig.deleteFile(this.getNextDynamicConfigFilename());
            }
            if ((qs = qv.getAllMembers().get(this.getId())) != null) {
                this.setQuorumAddress(qs.addr);
                this.setElectionAddress(qs.electionAddr);
                this.setClientAddress(qs.clientAddr);
            }
            return prevQV;
        }
    }

    private String makeDynamicConfigFilename(long version) {
        return this.configFilename + ".dynamic." + Long.toHexString(version);
    }

    private boolean needEraseClientInfoFromStaticConfig() {
        QuorumServer server = this.quorumVerifier.getAllMembers().get(this.getId());
        return server != null && server.clientAddr != null;
    }

    public Election getElectionAlg() {
        return this.electionAlg;
    }

    public int getSyncLimit() {
        return this.syncLimit;
    }

    public void setSyncLimit(int syncLimit) {
        this.syncLimit = syncLimit;
    }

    public boolean getSyncEnabled() {
        if (System.getProperty(SYNC_ENABLED) != null) {
            LOG.info("zookeeper.observer.syncEnabled=" + Boolean.getBoolean(SYNC_ENABLED));
            return Boolean.getBoolean(SYNC_ENABLED);
        }
        return this.syncEnabled;
    }

    public void setSyncEnabled(boolean syncEnabled) {
        this.syncEnabled = syncEnabled;
    }

    public int getElectionType() {
        return this.electionType;
    }

    public void setElectionType(int electionType) {
        this.electionType = electionType;
    }

    public boolean getQuorumListenOnAllIPs() {
        return this.quorumListenOnAllIPs;
    }

    public void setQuorumListenOnAllIPs(boolean quorumListenOnAllIPs) {
        this.quorumListenOnAllIPs = quorumListenOnAllIPs;
    }

    public void setCnxnFactory(ServerCnxnFactory cnxnFactory) {
        this.cnxnFactory = cnxnFactory;
    }

    public void setSecureCnxnFactory(ServerCnxnFactory secureCnxnFactory) {
        this.secureCnxnFactory = secureCnxnFactory;
    }

    private void startServerCnxnFactory() {
        if (this.cnxnFactory != null) {
            this.cnxnFactory.start();
        }
        if (this.secureCnxnFactory != null) {
            this.secureCnxnFactory.start();
        }
    }

    private void shutdownServerCnxnFactory() {
        if (this.cnxnFactory != null) {
            this.cnxnFactory.shutdown();
        }
        if (this.secureCnxnFactory != null) {
            this.secureCnxnFactory.shutdown();
        }
    }

    public void setZooKeeperServer(ZooKeeperServer zks) {
        if (this.cnxnFactory != null) {
            this.cnxnFactory.setZooKeeperServer(zks);
        }
        if (this.secureCnxnFactory != null) {
            this.secureCnxnFactory.setZooKeeperServer(zks);
        }
    }

    public void closeAllConnections() {
        if (this.cnxnFactory != null) {
            this.cnxnFactory.closeAll();
        }
        if (this.secureCnxnFactory != null) {
            this.secureCnxnFactory.closeAll();
        }
    }

    public int getClientPort() {
        if (this.cnxnFactory != null) {
            return this.cnxnFactory.getLocalPort();
        }
        return -1;
    }

    public void setTxnFactory(FileTxnSnapLog factory) {
        this.logFactory = factory;
    }

    public FileTxnSnapLog getTxnFactory() {
        return this.logFactory;
    }

    public void setZKDatabase(ZKDatabase database) {
        this.zkDb = database;
    }

    protected ZKDatabase getZkDb() {
        return this.zkDb;
    }

    public synchronized void initConfigInZKDatabase() {
        if (this.zkDb != null) {
            this.zkDb.initConfigInZKDatabase(this.getQuorumVerifier());
        }
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public boolean isRunning() {
        return this.running;
    }

    public QuorumCnxManager getQuorumCnxManager() {
        return this.qcm;
    }

    private long readLongFromFile(String name) throws IOException {
        File file = new File(this.logFactory.getSnapDir(), name);
        String line = "";
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            line = br.readLine();
            long l2 = Long.parseLong(line);
            return l2;
        }
    }

    private void writeLongToFile(String name, final long value) throws IOException {
        File file = new File(this.logFactory.getSnapDir(), name);
        new AtomicFileWritingIdiom(file, new AtomicFileWritingIdiom.WriterStatement(){

            @Override
            public void write(Writer bw) throws IOException {
                bw.write(Long.toString(value));
            }
        });
    }

    public long getCurrentEpoch() throws IOException {
        if (this.currentEpoch == -1L) {
            this.currentEpoch = this.readLongFromFile(CURRENT_EPOCH_FILENAME);
        }
        return this.currentEpoch;
    }

    public long getAcceptedEpoch() throws IOException {
        if (this.acceptedEpoch == -1L) {
            this.acceptedEpoch = this.readLongFromFile(ACCEPTED_EPOCH_FILENAME);
        }
        return this.acceptedEpoch;
    }

    public void setCurrentEpoch(long e2) throws IOException {
        this.currentEpoch = e2;
        this.writeLongToFile(CURRENT_EPOCH_FILENAME, e2);
    }

    public void setAcceptedEpoch(long e2) throws IOException {
        this.acceptedEpoch = e2;
        this.writeLongToFile(ACCEPTED_EPOCH_FILENAME, e2);
    }

    public boolean processReconfig(QuorumVerifier qv, Long suggestedLeaderId, Long zxid, boolean restartLE) {
        InetSocketAddress oldClientAddr = this.getClientAddress();
        QuorumVerifier prevQV = this.setQuorumVerifier(qv, true);
        this.initConfigInZKDatabase();
        if (prevQV.getVersion() < qv.getVersion() && !prevQV.equals(qv)) {
            QuorumServer myNewQS;
            Map<Long, QuorumServer> newMembers = qv.getAllMembers();
            this.updateRemotePeerMXBeans(newMembers);
            if (restartLE) {
                this.restartLeaderElection(prevQV, qv);
            }
            if ((myNewQS = newMembers.get(this.getId())) != null && myNewQS.clientAddr != null && !myNewQS.clientAddr.equals(oldClientAddr)) {
                this.cnxnFactory.reconfigure(myNewQS.clientAddr);
                this.updateThreadName();
            }
            boolean roleChange = this.updateLearnerType(qv);
            boolean leaderChange = false;
            if (suggestedLeaderId != null) {
                leaderChange = this.updateVote(suggestedLeaderId, zxid);
            } else {
                long currentLeaderId = this.getCurrentVote().getId();
                QuorumServer myleaderInCurQV = prevQV.getVotingMembers().get(currentLeaderId);
                QuorumServer myleaderInNewQV = qv.getVotingMembers().get(currentLeaderId);
                leaderChange = myleaderInCurQV == null || myleaderInCurQV.addr == null || myleaderInNewQV == null || !myleaderInCurQV.addr.equals(myleaderInNewQV.addr);
                this.reconfigFlagClear();
            }
            if (roleChange || leaderChange) {
                return true;
            }
        }
        return false;
    }

    private void updateRemotePeerMXBeans(Map<Long, QuorumServer> newMembers) {
        RemotePeerBean rBean;
        HashSet<Long> existingMembers = new HashSet<Long>(newMembers.keySet());
        existingMembers.retainAll(this.jmxRemotePeerBean.keySet());
        for (Long id : existingMembers) {
            RemotePeerBean rBean2 = this.jmxRemotePeerBean.get(id);
            rBean2.setQuorumServer(newMembers.get(id));
        }
        HashSet<Long> joiningMembers = new HashSet<Long>(newMembers.keySet());
        joiningMembers.removeAll(this.jmxRemotePeerBean.keySet());
        joiningMembers.remove(this.getId());
        for (Long id : joiningMembers) {
            QuorumServer qs = newMembers.get(id);
            rBean = new RemotePeerBean(qs);
            try {
                MBeanRegistry.getInstance().register(rBean, this.jmxQuorumBean);
                this.jmxRemotePeerBean.put(qs.id, rBean);
            }
            catch (Exception e2) {
                LOG.warn("Failed to register with JMX", e2);
            }
        }
        HashSet<Long> leavingMembers = new HashSet<Long>(this.jmxRemotePeerBean.keySet());
        leavingMembers.removeAll(newMembers.keySet());
        for (Long id : leavingMembers) {
            rBean = this.jmxRemotePeerBean.remove(id);
            try {
                MBeanRegistry.getInstance().unregister(rBean);
            }
            catch (Exception e3) {
                LOG.warn("Failed to unregister with JMX", e3);
            }
        }
    }

    private boolean updateLearnerType(QuorumVerifier newQV) {
        if (newQV.getObservingMembers().containsKey(this.getId())) {
            if (this.getLearnerType() != LearnerType.OBSERVER) {
                this.setLearnerType(LearnerType.OBSERVER);
                LOG.info("Becoming an observer");
                this.reconfigFlagSet();
                return true;
            }
            return false;
        }
        if (newQV.getVotingMembers().containsKey(this.getId())) {
            if (this.getLearnerType() != LearnerType.PARTICIPANT) {
                this.setLearnerType(LearnerType.PARTICIPANT);
                LOG.info("Becoming a voting participant");
                this.reconfigFlagSet();
                return true;
            }
            return false;
        }
        if (this.getLearnerType() != LearnerType.PARTICIPANT) {
            this.setLearnerType(LearnerType.PARTICIPANT);
            LOG.info("Becoming a non-voting participant");
            this.reconfigFlagSet();
            return true;
        }
        return false;
    }

    private boolean updateVote(long designatedLeader, long zxid) {
        Vote currentVote = this.getCurrentVote();
        if (currentVote != null && designatedLeader != currentVote.getId()) {
            this.setCurrentVote(new Vote(designatedLeader, zxid));
            this.reconfigFlagSet();
            LOG.warn("Suggested leader: " + designatedLeader);
            return true;
        }
        return false;
    }

    protected void updateElectionVote(long newEpoch) {
        Vote currentVote = this.getCurrentVote();
        if (currentVote != null) {
            this.setCurrentVote(new Vote(currentVote.getId(), currentVote.getZxid(), currentVote.getElectionEpoch(), newEpoch, currentVote.getState()));
        }
    }

    private void updateThreadName() {
        String plain = this.cnxnFactory != null ? (this.cnxnFactory.getLocalAddress() != null ? this.cnxnFactory.getLocalAddress().toString() : "disabled") : "disabled";
        String secure = this.secureCnxnFactory != null ? this.secureCnxnFactory.getLocalAddress().toString() : "disabled";
        this.setName(String.format("QuorumPeer[myid=%d](plain=%s)(secure=%s)", this.getId(), plain, secure));
    }

    void setElectionTimeTaken(long electionTimeTaken) {
        this.electionTimeTaken = electionTimeTaken;
    }

    long getElectionTimeTaken() {
        return this.electionTimeTaken;
    }

    @Deprecated
    class ResponderThread
    extends ZooKeeperThread {
        volatile boolean running;

        ResponderThread() {
            super("ResponderThread");
            this.running = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                byte[] b2 = new byte[36];
                ByteBuffer responseBuffer = ByteBuffer.wrap(b2);
                DatagramPacket packet = new DatagramPacket(b2, b2.length);
                while (this.running) {
                    QuorumPeer.this.udpSocket.receive(packet);
                    if (packet.getLength() != 4) {
                        LOG.warn("Got more than just an xid! Len = " + packet.getLength());
                    } else {
                        responseBuffer.clear();
                        responseBuffer.getInt();
                        responseBuffer.putLong(QuorumPeer.this.myid);
                        Vote current = QuorumPeer.this.getCurrentVote();
                        switch (QuorumPeer.this.getPeerState()) {
                            case LOOKING: {
                                responseBuffer.putLong(current.getId());
                                responseBuffer.putLong(current.getZxid());
                                break;
                            }
                            case LEADING: {
                                responseBuffer.putLong(QuorumPeer.this.myid);
                                try {
                                    long proposed;
                                    Leader leader = QuorumPeer.this.leader;
                                    synchronized (leader) {
                                        proposed = QuorumPeer.this.leader.lastProposed;
                                    }
                                    responseBuffer.putLong(proposed);
                                }
                                catch (NullPointerException npe) {}
                                break;
                            }
                            case FOLLOWING: {
                                responseBuffer.putLong(current.getId());
                                try {
                                    responseBuffer.putLong(QuorumPeer.this.follower.getZxid());
                                }
                                catch (NullPointerException npe) {}
                                break;
                            }
                        }
                        packet.setData(b2);
                        QuorumPeer.this.udpSocket.send(packet);
                    }
                    packet.setLength(b2.length);
                }
            }
            catch (RuntimeException e2) {
                LOG.warn("Unexpected runtime exception in ResponderThread", e2);
            }
            catch (IOException e3) {
                LOG.warn("Unexpected IO exception in ResponderThread", e3);
            }
            finally {
                LOG.warn("QuorumPeer responder thread exited");
            }
        }
    }

    public static enum LearnerType {
        PARTICIPANT,
        OBSERVER;

    }

    public static enum ServerState {
        LOOKING,
        FOLLOWING,
        LEADING,
        OBSERVING;

    }

    public static class QuorumServer {
        public InetSocketAddress addr = null;
        public InetSocketAddress electionAddr = null;
        public InetSocketAddress clientAddr = null;
        public long id;
        public LearnerType type = LearnerType.PARTICIPANT;
        private List<InetSocketAddress> myAddrs;
        private static final String wrongFormat = " does not have the form server_config or server_config;client_config where server_config is host:port:port or host:port:port:type and client_config is port or host:port";

        public QuorumServer(long id, InetSocketAddress addr, InetSocketAddress electionAddr, InetSocketAddress clientAddr) {
            this(id, addr, electionAddr, clientAddr, LearnerType.PARTICIPANT);
        }

        public QuorumServer(long id, InetSocketAddress addr, InetSocketAddress electionAddr) {
            this(id, addr, electionAddr, null, LearnerType.PARTICIPANT);
        }

        public QuorumServer(long id, InetSocketAddress addr) {
            this(id, addr, null, null, LearnerType.PARTICIPANT);
        }

        public void recreateSocketAddresses() {
            if (this.addr == null) {
                LOG.warn("Server address has not been initialized");
                return;
            }
            if (this.electionAddr == null) {
                LOG.warn("Election address has not been initialized");
                return;
            }
            String host = this.addr.getHostString();
            InetAddress address = null;
            try {
                address = InetAddress.getByName(host);
            }
            catch (UnknownHostException ex) {
                LOG.warn("Failed to resolve address: {}", (Object)host, (Object)ex);
                return;
            }
            LOG.debug("Resolved address for {}: {}", (Object)host, (Object)address);
            int port = this.addr.getPort();
            this.addr = new InetSocketAddress(address, port);
            port = this.electionAddr.getPort();
            this.electionAddr = new InetSocketAddress(address, port);
        }

        private void setType(String s2) throws QuorumPeerConfig.ConfigException {
            if (s2.toLowerCase().equals("observer")) {
                this.type = LearnerType.OBSERVER;
            } else if (s2.toLowerCase().equals("participant")) {
                this.type = LearnerType.PARTICIPANT;
            } else {
                throw new QuorumPeerConfig.ConfigException("Unrecognised peertype: " + s2);
            }
        }

        private static String[] splitWithLeadingHostname(String s2) throws QuorumPeerConfig.ConfigException {
            if (s2.startsWith("[")) {
                int i2 = s2.indexOf("]:");
                if (i2 < 0) {
                    throw new QuorumPeerConfig.ConfigException(s2 + " starts with '[' but has no matching ']:'");
                }
                String[] sa = s2.substring(i2 + 2).split(":");
                String[] nsa = new String[sa.length + 1];
                nsa[0] = s2.substring(1, i2);
                System.arraycopy(sa, 0, nsa, 1, sa.length);
                return nsa;
            }
            return s2.split(":");
        }

        public QuorumServer(long sid, String addressStr) throws QuorumPeerConfig.ConfigException {
            this.id = sid;
            String[] serverClientParts = addressStr.split(";");
            String[] serverParts = QuorumServer.splitWithLeadingHostname(serverClientParts[0]);
            if (serverClientParts.length > 2 || serverParts.length < 3 || serverParts.length > 4) {
                throw new QuorumPeerConfig.ConfigException(addressStr + wrongFormat);
            }
            if (serverClientParts.length == 2) {
                String[] clientParts = QuorumServer.splitWithLeadingHostname(serverClientParts[1]);
                if (clientParts.length > 2) {
                    throw new QuorumPeerConfig.ConfigException(addressStr + wrongFormat);
                }
                String hostname = clientParts.length == 2 ? clientParts[0] : "0.0.0.0";
                try {
                    this.clientAddr = new InetSocketAddress(hostname, Integer.parseInt(clientParts[clientParts.length - 1]));
                }
                catch (NumberFormatException e2) {
                    throw new QuorumPeerConfig.ConfigException("Address unresolved: " + hostname + ":" + clientParts[clientParts.length - 1]);
                }
            }
            try {
                this.addr = new InetSocketAddress(serverParts[0], Integer.parseInt(serverParts[1]));
            }
            catch (NumberFormatException e3) {
                throw new QuorumPeerConfig.ConfigException("Address unresolved: " + serverParts[0] + ":" + serverParts[1]);
            }
            try {
                this.electionAddr = new InetSocketAddress(serverParts[0], Integer.parseInt(serverParts[2]));
            }
            catch (NumberFormatException e4) {
                throw new QuorumPeerConfig.ConfigException("Address unresolved: " + serverParts[0] + ":" + serverParts[2]);
            }
            if (serverParts.length == 4) {
                this.setType(serverParts[3]);
            }
            this.setMyAddrs();
        }

        public QuorumServer(long id, InetSocketAddress addr, InetSocketAddress electionAddr, LearnerType type) {
            this(id, addr, electionAddr, null, type);
        }

        public QuorumServer(long id, InetSocketAddress addr, InetSocketAddress electionAddr, InetSocketAddress clientAddr, LearnerType type) {
            this.id = id;
            this.addr = addr;
            this.electionAddr = electionAddr;
            this.type = type;
            this.clientAddr = clientAddr;
            this.setMyAddrs();
        }

        private void setMyAddrs() {
            this.myAddrs = new ArrayList<InetSocketAddress>();
            this.myAddrs.add(this.addr);
            this.myAddrs.add(this.clientAddr);
            this.myAddrs.add(this.electionAddr);
            this.myAddrs = this.excludedSpecialAddresses(this.myAddrs);
        }

        private static String delimitedHostString(InetSocketAddress addr) {
            String host = addr.getHostString();
            if (host.contains(":")) {
                return "[" + host + "]";
            }
            return host;
        }

        public String toString() {
            StringWriter sw = new StringWriter();
            if (this.addr != null) {
                sw.append(QuorumServer.delimitedHostString(this.addr));
                sw.append(":");
                sw.append(String.valueOf(this.addr.getPort()));
            }
            if (this.electionAddr != null) {
                sw.append(":");
                sw.append(String.valueOf(this.electionAddr.getPort()));
            }
            if (this.type == LearnerType.OBSERVER) {
                sw.append(":observer");
            } else if (this.type == LearnerType.PARTICIPANT) {
                sw.append(":participant");
            }
            if (this.clientAddr != null) {
                sw.append(";");
                sw.append(QuorumServer.delimitedHostString(this.clientAddr));
                sw.append(":");
                sw.append(String.valueOf(this.clientAddr.getPort()));
            }
            return sw.toString();
        }

        public int hashCode() {
            assert (false) : "hashCode not designed";
            return 42;
        }

        private boolean checkAddressesEqual(InetSocketAddress addr1, InetSocketAddress addr2) {
            return !(addr1 == null && addr2 != null || addr1 != null && addr2 == null) && (addr1 == null || addr2 == null || addr1.equals(addr2));
        }

        public boolean equals(Object o2) {
            if (!(o2 instanceof QuorumServer)) {
                return false;
            }
            QuorumServer qs = (QuorumServer)o2;
            if (qs.id != this.id || qs.type != this.type) {
                return false;
            }
            if (!this.checkAddressesEqual(this.addr, qs.addr)) {
                return false;
            }
            if (!this.checkAddressesEqual(this.electionAddr, qs.electionAddr)) {
                return false;
            }
            return this.checkAddressesEqual(this.clientAddr, qs.clientAddr);
        }

        public void checkAddressDuplicate(QuorumServer s2) throws KeeperException.BadArgumentsException {
            List<InetSocketAddress> otherAddrs = new ArrayList<InetSocketAddress>();
            otherAddrs.add(s2.addr);
            otherAddrs.add(s2.clientAddr);
            otherAddrs.add(s2.electionAddr);
            otherAddrs = this.excludedSpecialAddresses(otherAddrs);
            for (InetSocketAddress my : this.myAddrs) {
                for (InetSocketAddress other : otherAddrs) {
                    if (!my.equals(other)) continue;
                    String error = String.format("%s of server.%d conflicts %s of server.%d", my, this.id, other, s2.id);
                    throw new KeeperException.BadArgumentsException(error);
                }
            }
        }

        private List<InetSocketAddress> excludedSpecialAddresses(List<InetSocketAddress> addrs) {
            ArrayList<InetSocketAddress> included = new ArrayList<InetSocketAddress>();
            InetAddress wcAddr = new InetSocketAddress(0).getAddress();
            for (InetSocketAddress addr : addrs) {
                InetAddress inetaddr;
                if (addr == null || (inetaddr = addr.getAddress()) == null || inetaddr.equals(wcAddr) || inetaddr.isLoopbackAddress()) continue;
                included.add(addr);
            }
            return included;
        }
    }
}

