/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel;

import java.util.ArrayList;
import org.jboss.netty.channel.ReceiveBufferSizePredictor;

public class AdaptiveReceiveBufferSizePredictor
implements ReceiveBufferSizePredictor {
    static final int DEFAULT_MINIMUM = 64;
    static final int DEFAULT_INITIAL = 1024;
    static final int DEFAULT_MAXIMUM = 65536;
    private static final int INDEX_INCREMENT = 4;
    private static final int INDEX_DECREMENT = 1;
    private static final int[] SIZE_TABLE;
    private final int minIndex;
    private final int maxIndex;
    private int index;
    private int nextReceiveBufferSize;
    private boolean decreaseNow;

    private static int getSizeTableIndex(int size) {
        if (size <= 16) {
            return size - 1;
        }
        int bits = 0;
        int v = size;
        do {
            ++bits;
        } while ((v >>>= 1) != 0);
        int baseIdx = bits << 3;
        int startIdx = baseIdx - 18;
        int endIdx = baseIdx - 25;
        for (int i2 = startIdx; i2 >= endIdx; --i2) {
            if (size < SIZE_TABLE[i2]) continue;
            return i2;
        }
        throw new Error("shouldn't reach here; please file a bug report.");
    }

    public AdaptiveReceiveBufferSizePredictor() {
        this(64, 1024, 65536);
    }

    public AdaptiveReceiveBufferSizePredictor(int minimum, int initial, int maximum) {
        if (minimum <= 0) {
            throw new IllegalArgumentException("minimum: " + minimum);
        }
        if (initial < minimum) {
            throw new IllegalArgumentException("initial: " + initial);
        }
        if (maximum < initial) {
            throw new IllegalArgumentException("maximum: " + maximum);
        }
        int minIndex = AdaptiveReceiveBufferSizePredictor.getSizeTableIndex(minimum);
        this.minIndex = SIZE_TABLE[minIndex] < minimum ? minIndex + 1 : minIndex;
        int maxIndex = AdaptiveReceiveBufferSizePredictor.getSizeTableIndex(maximum);
        this.maxIndex = SIZE_TABLE[maxIndex] > maximum ? maxIndex - 1 : maxIndex;
        this.index = AdaptiveReceiveBufferSizePredictor.getSizeTableIndex(initial);
        this.nextReceiveBufferSize = SIZE_TABLE[this.index];
    }

    public int nextReceiveBufferSize() {
        return this.nextReceiveBufferSize;
    }

    public void previousReceiveBufferSize(int previousReceiveBufferSize) {
        if (previousReceiveBufferSize <= SIZE_TABLE[Math.max(0, this.index - 1 - 1)]) {
            if (this.decreaseNow) {
                this.index = Math.max(this.index - 1, this.minIndex);
                this.nextReceiveBufferSize = SIZE_TABLE[this.index];
                this.decreaseNow = false;
            } else {
                this.decreaseNow = true;
            }
        } else if (previousReceiveBufferSize >= this.nextReceiveBufferSize) {
            this.index = Math.min(this.index + 4, this.maxIndex);
            this.nextReceiveBufferSize = SIZE_TABLE[this.index];
            this.decreaseNow = false;
        }
    }

    static {
        int i2;
        ArrayList<Integer> sizeTable = new ArrayList<Integer>();
        for (i2 = 1; i2 <= 8; ++i2) {
            sizeTable.add(i2);
        }
        for (i2 = 4; i2 < 32; ++i2) {
            long v = 1L << i2;
            long inc = v >>> 4;
            v -= inc << 3;
            for (int j2 = 0; j2 < 8; ++j2) {
                if ((v += inc) > Integer.MAX_VALUE) {
                    sizeTable.add(Integer.MAX_VALUE);
                    continue;
                }
                sizeTable.add((int)v);
            }
        }
        SIZE_TABLE = new int[sizeTable.size()];
        for (i2 = 0; i2 < SIZE_TABLE.length; ++i2) {
            AdaptiveReceiveBufferSizePredictor.SIZE_TABLE[i2] = (Integer)sizeTable.get(i2);
        }
    }
}

