/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel;

import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.ChildChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.WriteCompletionEvent;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;

public class SimpleChannelHandler
implements ChannelUpstreamHandler,
ChannelDownstreamHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SimpleChannelHandler.class.getName());

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e2) throws Exception {
        if (e2 instanceof MessageEvent) {
            this.messageReceived(ctx, (MessageEvent)e2);
        } else if (e2 instanceof WriteCompletionEvent) {
            WriteCompletionEvent evt = (WriteCompletionEvent)e2;
            this.writeComplete(ctx, evt);
        } else if (e2 instanceof ChildChannelStateEvent) {
            ChildChannelStateEvent evt = (ChildChannelStateEvent)e2;
            if (evt.getChildChannel().isOpen()) {
                this.childChannelOpen(ctx, evt);
            } else {
                this.childChannelClosed(ctx, evt);
            }
        } else if (e2 instanceof ChannelStateEvent) {
            ChannelStateEvent evt = (ChannelStateEvent)e2;
            switch (evt.getState()) {
                case OPEN: {
                    if (Boolean.TRUE.equals(evt.getValue())) {
                        this.channelOpen(ctx, evt);
                        break;
                    }
                    this.channelClosed(ctx, evt);
                    break;
                }
                case BOUND: {
                    if (evt.getValue() != null) {
                        this.channelBound(ctx, evt);
                        break;
                    }
                    this.channelUnbound(ctx, evt);
                    break;
                }
                case CONNECTED: {
                    if (evt.getValue() != null) {
                        this.channelConnected(ctx, evt);
                        break;
                    }
                    this.channelDisconnected(ctx, evt);
                    break;
                }
                case INTEREST_OPS: {
                    this.channelInterestChanged(ctx, evt);
                    break;
                }
                default: {
                    ctx.sendUpstream(e2);
                    break;
                }
            }
        } else if (e2 instanceof ExceptionEvent) {
            this.exceptionCaught(ctx, (ExceptionEvent)e2);
        } else {
            ctx.sendUpstream(e2);
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e2) throws Exception {
        ctx.sendUpstream(e2);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e2) throws Exception {
        if (this == ctx.getPipeline().getLast()) {
            logger.warn("EXCEPTION, please implement " + this.getClass().getName() + ".exceptionCaught() for proper handling.", e2.getCause());
        }
        ctx.sendUpstream(e2);
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e2) throws Exception {
        ctx.sendUpstream(e2);
    }

    public void channelBound(ChannelHandlerContext ctx, ChannelStateEvent e2) throws Exception {
        ctx.sendUpstream(e2);
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e2) throws Exception {
        ctx.sendUpstream(e2);
    }

    public void channelInterestChanged(ChannelHandlerContext ctx, ChannelStateEvent e2) throws Exception {
        ctx.sendUpstream(e2);
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e2) throws Exception {
        ctx.sendUpstream(e2);
    }

    public void channelUnbound(ChannelHandlerContext ctx, ChannelStateEvent e2) throws Exception {
        ctx.sendUpstream(e2);
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e2) throws Exception {
        ctx.sendUpstream(e2);
    }

    public void writeComplete(ChannelHandlerContext ctx, WriteCompletionEvent e2) throws Exception {
        ctx.sendUpstream(e2);
    }

    public void childChannelOpen(ChannelHandlerContext ctx, ChildChannelStateEvent e2) throws Exception {
        ctx.sendUpstream(e2);
    }

    public void childChannelClosed(ChannelHandlerContext ctx, ChildChannelStateEvent e2) throws Exception {
        ctx.sendUpstream(e2);
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e2) throws Exception {
        block10: {
            block11: {
                block9: {
                    if (!(e2 instanceof MessageEvent)) break block9;
                    this.writeRequested(ctx, (MessageEvent)e2);
                    break block10;
                }
                if (!(e2 instanceof ChannelStateEvent)) break block11;
                ChannelStateEvent evt = (ChannelStateEvent)e2;
                switch (evt.getState()) {
                    case OPEN: {
                        if (!Boolean.TRUE.equals(evt.getValue())) {
                            this.closeRequested(ctx, evt);
                            break;
                        }
                        break block10;
                    }
                    case BOUND: {
                        if (evt.getValue() != null) {
                            this.bindRequested(ctx, evt);
                            break;
                        }
                        this.unbindRequested(ctx, evt);
                        break;
                    }
                    case CONNECTED: {
                        if (evt.getValue() != null) {
                            this.connectRequested(ctx, evt);
                            break;
                        }
                        this.disconnectRequested(ctx, evt);
                        break;
                    }
                    case INTEREST_OPS: {
                        this.setInterestOpsRequested(ctx, evt);
                        break;
                    }
                    default: {
                        ctx.sendDownstream(e2);
                        break;
                    }
                }
                break block10;
            }
            ctx.sendDownstream(e2);
        }
    }

    public void writeRequested(ChannelHandlerContext ctx, MessageEvent e2) throws Exception {
        ctx.sendDownstream(e2);
    }

    public void bindRequested(ChannelHandlerContext ctx, ChannelStateEvent e2) throws Exception {
        ctx.sendDownstream(e2);
    }

    public void connectRequested(ChannelHandlerContext ctx, ChannelStateEvent e2) throws Exception {
        ctx.sendDownstream(e2);
    }

    public void setInterestOpsRequested(ChannelHandlerContext ctx, ChannelStateEvent e2) throws Exception {
        ctx.sendDownstream(e2);
    }

    public void disconnectRequested(ChannelHandlerContext ctx, ChannelStateEvent e2) throws Exception {
        ctx.sendDownstream(e2);
    }

    public void unbindRequested(ChannelHandlerContext ctx, ChannelStateEvent e2) throws Exception {
        ctx.sendDownstream(e2);
    }

    public void closeRequested(ChannelHandlerContext ctx, ChannelStateEvent e2) throws Exception {
        ctx.sendDownstream(e2);
    }
}

