/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.group;

import java.net.SocketAddress;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ServerChannel;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.CombinedIterator;
import org.jboss.netty.channel.group.DefaultChannelGroupFuture;
import org.jboss.netty.util.internal.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultChannelGroup
extends AbstractSet<Channel>
implements ChannelGroup {
    private static final AtomicInteger nextId = new AtomicInteger();
    private final String name;
    private final ConcurrentMap<Integer, Channel> serverChannels = new ConcurrentHashMap<Integer, Channel>();
    private final ConcurrentMap<Integer, Channel> nonServerChannels = new ConcurrentHashMap<Integer, Channel>();
    private final ChannelFutureListener remover = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture future) throws Exception {
            DefaultChannelGroup.this.remove(future.getChannel());
        }
    };

    public DefaultChannelGroup() {
        this("group-0x" + Integer.toHexString(nextId.incrementAndGet()));
    }

    public DefaultChannelGroup(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isEmpty() {
        return this.nonServerChannels.isEmpty() && this.serverChannels.isEmpty();
    }

    @Override
    public int size() {
        return this.nonServerChannels.size() + this.serverChannels.size();
    }

    @Override
    public Channel find(Integer id) {
        Channel c2 = (Channel)this.nonServerChannels.get(id);
        if (c2 != null) {
            return c2;
        }
        return (Channel)this.serverChannels.get(id);
    }

    @Override
    public boolean contains(Object o2) {
        if (o2 instanceof Integer) {
            return this.nonServerChannels.containsKey(o2) || this.serverChannels.containsKey(o2);
        }
        if (o2 instanceof Channel) {
            Channel c2 = (Channel)o2;
            if (o2 instanceof ServerChannel) {
                return this.serverChannels.containsKey(c2.getId());
            }
            return this.nonServerChannels.containsKey(c2.getId());
        }
        return false;
    }

    @Override
    public boolean add(Channel channel) {
        boolean added;
        ConcurrentMap<Integer, Channel> map = channel instanceof ServerChannel ? this.serverChannels : this.nonServerChannels;
        boolean bl = added = map.putIfAbsent(channel.getId(), channel) == null;
        if (added) {
            channel.getCloseFuture().addListener(this.remover);
        }
        return added;
    }

    @Override
    public boolean remove(Object o2) {
        Channel c2 = null;
        if (o2 instanceof Integer) {
            c2 = (Channel)this.nonServerChannels.remove(o2);
            if (c2 == null) {
                c2 = (Channel)this.serverChannels.remove(o2);
            }
        } else if (o2 instanceof Channel) {
            c2 = (Channel)o2;
            c2 = c2 instanceof ServerChannel ? (Channel)this.serverChannels.remove(c2.getId()) : (Channel)this.nonServerChannels.remove(c2.getId());
        }
        if (c2 == null) {
            return false;
        }
        c2.getCloseFuture().removeListener(this.remover);
        return true;
    }

    @Override
    public void clear() {
        this.nonServerChannels.clear();
        this.serverChannels.clear();
    }

    @Override
    public Iterator<Channel> iterator() {
        return new CombinedIterator<Channel>(this.serverChannels.values().iterator(), this.nonServerChannels.values().iterator());
    }

    @Override
    public Object[] toArray() {
        ArrayList channels = new ArrayList(this.size());
        channels.addAll(this.serverChannels.values());
        channels.addAll(this.nonServerChannels.values());
        return channels.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a2) {
        ArrayList channels = new ArrayList(this.size());
        channels.addAll(this.serverChannels.values());
        channels.addAll(this.nonServerChannels.values());
        return channels.toArray(a2);
    }

    @Override
    public ChannelGroupFuture close() {
        LinkedHashMap<Integer, ChannelFuture> futures = new LinkedHashMap<Integer, ChannelFuture>(this.size());
        for (Channel c2 : this.serverChannels.values()) {
            futures.put(c2.getId(), c2.close().awaitUninterruptibly());
        }
        for (Channel c2 : this.nonServerChannels.values()) {
            futures.put(c2.getId(), c2.close());
        }
        return new DefaultChannelGroupFuture((ChannelGroup)this, futures);
    }

    @Override
    public ChannelGroupFuture disconnect() {
        LinkedHashMap<Integer, ChannelFuture> futures = new LinkedHashMap<Integer, ChannelFuture>(this.size());
        for (Channel c2 : this.serverChannels.values()) {
            futures.put(c2.getId(), c2.disconnect().awaitUninterruptibly());
        }
        for (Channel c2 : this.nonServerChannels.values()) {
            futures.put(c2.getId(), c2.disconnect());
        }
        return new DefaultChannelGroupFuture((ChannelGroup)this, futures);
    }

    @Override
    public ChannelGroupFuture setInterestOps(int interestOps) {
        LinkedHashMap<Integer, ChannelFuture> futures = new LinkedHashMap<Integer, ChannelFuture>(this.size());
        for (Channel c2 : this.serverChannels.values()) {
            futures.put(c2.getId(), c2.setInterestOps(interestOps).awaitUninterruptibly());
        }
        for (Channel c2 : this.nonServerChannels.values()) {
            futures.put(c2.getId(), c2.setInterestOps(interestOps));
        }
        return new DefaultChannelGroupFuture((ChannelGroup)this, futures);
    }

    @Override
    public ChannelGroupFuture setReadable(boolean readable) {
        LinkedHashMap<Integer, ChannelFuture> futures = new LinkedHashMap<Integer, ChannelFuture>(this.size());
        for (Channel c2 : this.serverChannels.values()) {
            futures.put(c2.getId(), c2.setReadable(readable).awaitUninterruptibly());
        }
        for (Channel c2 : this.nonServerChannels.values()) {
            futures.put(c2.getId(), c2.setReadable(readable));
        }
        return new DefaultChannelGroupFuture((ChannelGroup)this, futures);
    }

    @Override
    public ChannelGroupFuture unbind() {
        LinkedHashMap<Integer, ChannelFuture> futures = new LinkedHashMap<Integer, ChannelFuture>(this.size());
        for (Channel c2 : this.serverChannels.values()) {
            futures.put(c2.getId(), c2.unbind().awaitUninterruptibly());
        }
        for (Channel c2 : this.nonServerChannels.values()) {
            futures.put(c2.getId(), c2.unbind());
        }
        return new DefaultChannelGroupFuture((ChannelGroup)this, futures);
    }

    @Override
    public ChannelGroupFuture write(Object message) {
        LinkedHashMap<Integer, ChannelFuture> futures = new LinkedHashMap<Integer, ChannelFuture>(this.size());
        if (message instanceof ChannelBuffer) {
            ChannelBuffer buf = (ChannelBuffer)message;
            for (Channel c2 : this.nonServerChannels.values()) {
                futures.put(c2.getId(), c2.write(buf.duplicate()));
            }
        } else {
            for (Channel c3 : this.nonServerChannels.values()) {
                futures.put(c3.getId(), c3.write(message));
            }
        }
        return new DefaultChannelGroupFuture((ChannelGroup)this, futures);
    }

    @Override
    public ChannelGroupFuture write(Object message, SocketAddress remoteAddress) {
        LinkedHashMap<Integer, ChannelFuture> futures = new LinkedHashMap<Integer, ChannelFuture>(this.size());
        if (message instanceof ChannelBuffer) {
            ChannelBuffer buf = (ChannelBuffer)message;
            for (Channel c2 : this.nonServerChannels.values()) {
                futures.put(c2.getId(), c2.write(buf.duplicate(), remoteAddress));
            }
        } else {
            for (Channel c3 : this.nonServerChannels.values()) {
                futures.put(c3.getId(), c3.write(message, remoteAddress));
            }
        }
        return new DefaultChannelGroupFuture((ChannelGroup)this, futures);
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean equals(Object o2) {
        return this == o2;
    }

    @Override
    public int compareTo(ChannelGroup o2) {
        int v = this.getName().compareTo(o2.getName());
        if (v != 0) {
            return v;
        }
        return System.identityHashCode(this) - System.identityHashCode(o2);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(name: " + this.getName() + ", size: " + this.size() + ')';
    }
}

