/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.local;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketAddress;
import org.jboss.netty.channel.AbstractChannelSink;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.local.DefaultLocalChannel;
import org.jboss.netty.channel.local.DefaultLocalServerChannel;
import org.jboss.netty.channel.local.LocalAddress;
import org.jboss.netty.channel.local.LocalChannelRegistry;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;

final class LocalClientChannelSink
extends AbstractChannelSink {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(LocalClientChannelSink.class);

    LocalClientChannelSink() {
    }

    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e2) throws Exception {
        if (e2 instanceof ChannelStateEvent) {
            ChannelStateEvent event = (ChannelStateEvent)e2;
            DefaultLocalChannel channel = (DefaultLocalChannel)event.getChannel();
            ChannelFuture future = event.getFuture();
            ChannelState state = event.getState();
            Object value = event.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value)) break;
                    channel.closeNow(future);
                    break;
                }
                case BOUND: {
                    if (value != null) {
                        LocalClientChannelSink.bind(channel, future, (LocalAddress)value);
                        break;
                    }
                    channel.closeNow(future);
                    break;
                }
                case CONNECTED: {
                    if (value != null) {
                        this.connect(channel, future, (LocalAddress)value);
                        break;
                    }
                    channel.closeNow(future);
                    break;
                }
                case INTEREST_OPS: {
                    future.setSuccess();
                }
            }
        } else if (e2 instanceof MessageEvent) {
            MessageEvent event = (MessageEvent)e2;
            DefaultLocalChannel channel = (DefaultLocalChannel)event.getChannel();
            boolean offered = channel.writeBuffer.offer(event);
            assert (offered);
            channel.flushWriteBuffer();
        }
    }

    private static void bind(DefaultLocalChannel channel, ChannelFuture future, LocalAddress localAddress) {
        try {
            if (!LocalChannelRegistry.register(localAddress, channel)) {
                throw new ChannelException("address already in use: " + localAddress);
            }
            channel.setBound();
            channel.localAddress = localAddress;
            future.setSuccess();
            Channels.fireChannelBound(channel, (SocketAddress)localAddress);
        }
        catch (Throwable t) {
            LocalChannelRegistry.unregister(localAddress);
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    private void connect(DefaultLocalChannel channel, ChannelFuture future, LocalAddress remoteAddress) {
        DefaultLocalChannel acceptedChannel;
        ChannelPipeline pipeline;
        Channel remoteChannel = LocalChannelRegistry.getChannel(remoteAddress);
        if (!(remoteChannel instanceof DefaultLocalServerChannel)) {
            future.setFailure(new ConnectException("connection refused: " + remoteAddress));
            return;
        }
        DefaultLocalServerChannel serverChannel = (DefaultLocalServerChannel)remoteChannel;
        try {
            pipeline = serverChannel.getConfig().getPipelineFactory().getPipeline();
        }
        catch (Exception e2) {
            future.setFailure(e2);
            Channels.fireExceptionCaught(channel, (Throwable)e2);
            if (logger.isWarnEnabled()) {
                logger.warn("Failed to initialize an accepted socket.", e2);
            }
            return;
        }
        future.setSuccess();
        channel.pairedChannel = acceptedChannel = new DefaultLocalChannel(serverChannel, serverChannel.getFactory(), pipeline, this, channel);
        if (!channel.isBound()) {
            LocalClientChannelSink.bind(channel, Channels.succeededFuture(channel), new LocalAddress("ephemeral"));
        }
        channel.remoteAddress = serverChannel.getLocalAddress();
        channel.setConnected();
        Channels.fireChannelConnected(channel, (SocketAddress)serverChannel.getLocalAddress());
        acceptedChannel.localAddress = serverChannel.getLocalAddress();
        try {
            acceptedChannel.setBound();
        }
        catch (IOException e3) {
            throw new Error(e3);
        }
        Channels.fireChannelBound(acceptedChannel, (SocketAddress)channel.getRemoteAddress());
        acceptedChannel.remoteAddress = channel.getLocalAddress();
        acceptedChannel.setConnected();
        Channels.fireChannelConnected(acceptedChannel, (SocketAddress)channel.getLocalAddress());
        channel.flushWriteBuffer();
        acceptedChannel.flushWriteBuffer();
    }
}

