/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.local;

import java.net.SocketAddress;
import org.jboss.netty.channel.AbstractChannelSink;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.local.DefaultLocalChannel;
import org.jboss.netty.channel.local.DefaultLocalServerChannel;
import org.jboss.netty.channel.local.LocalAddress;
import org.jboss.netty.channel.local.LocalChannelRegistry;

final class LocalServerChannelSink
extends AbstractChannelSink {
    LocalServerChannelSink() {
    }

    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e2) throws Exception {
        Channel channel = e2.getChannel();
        if (channel instanceof DefaultLocalServerChannel) {
            LocalServerChannelSink.handleServerChannel(e2);
        } else if (channel instanceof DefaultLocalChannel) {
            LocalServerChannelSink.handleAcceptedChannel(e2);
        }
    }

    private static void handleServerChannel(ChannelEvent e2) {
        if (!(e2 instanceof ChannelStateEvent)) {
            return;
        }
        ChannelStateEvent event = (ChannelStateEvent)e2;
        DefaultLocalServerChannel channel = (DefaultLocalServerChannel)event.getChannel();
        ChannelFuture future = event.getFuture();
        ChannelState state = event.getState();
        Object value = event.getValue();
        switch (state) {
            case OPEN: {
                if (!Boolean.FALSE.equals(value)) break;
                LocalServerChannelSink.close(channel, future);
                break;
            }
            case BOUND: {
                if (value != null) {
                    LocalServerChannelSink.bind(channel, future, (LocalAddress)value);
                    break;
                }
                LocalServerChannelSink.close(channel, future);
            }
        }
    }

    private static void handleAcceptedChannel(ChannelEvent e2) {
        if (e2 instanceof ChannelStateEvent) {
            ChannelStateEvent event = (ChannelStateEvent)e2;
            DefaultLocalChannel channel = (DefaultLocalChannel)event.getChannel();
            ChannelFuture future = event.getFuture();
            ChannelState state = event.getState();
            Object value = event.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value)) break;
                    channel.closeNow(future);
                    break;
                }
                case BOUND: 
                case CONNECTED: {
                    if (value != null) break;
                    channel.closeNow(future);
                    break;
                }
                case INTEREST_OPS: {
                    future.setSuccess();
                }
            }
        } else if (e2 instanceof MessageEvent) {
            MessageEvent event = (MessageEvent)e2;
            DefaultLocalChannel channel = (DefaultLocalChannel)event.getChannel();
            boolean offered = channel.writeBuffer.offer(event);
            assert (offered);
            channel.flushWriteBuffer();
        }
    }

    private static void bind(DefaultLocalServerChannel channel, ChannelFuture future, LocalAddress localAddress) {
        try {
            if (!LocalChannelRegistry.register(localAddress, channel)) {
                throw new ChannelException("address already in use: " + localAddress);
            }
            if (!channel.bound.compareAndSet(false, true)) {
                throw new ChannelException("already bound");
            }
            channel.localAddress = localAddress;
            future.setSuccess();
            Channels.fireChannelBound(channel, (SocketAddress)localAddress);
        }
        catch (Throwable t) {
            LocalChannelRegistry.unregister(localAddress);
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    private static void close(DefaultLocalServerChannel channel, ChannelFuture future) {
        try {
            if (channel.setClosed()) {
                future.setSuccess();
                LocalAddress localAddress = channel.localAddress;
                if (channel.bound.compareAndSet(true, false)) {
                    channel.localAddress = null;
                    LocalChannelRegistry.unregister(localAddress);
                    Channels.fireChannelUnbound(channel);
                }
                Channels.fireChannelClosed(channel);
            } else {
                future.setSuccess();
            }
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }
}

