/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import java.net.InetSocketAddress;
import java.nio.channels.SelectableChannel;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.AbstractChannel;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelSink;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.socket.nio.AbstractNioWorker;
import org.jboss.netty.channel.socket.nio.NioChannelConfig;
import org.jboss.netty.channel.socket.nio.SocketSendBufferPool;
import org.jboss.netty.util.internal.ThreadLocalBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractNioChannel<C extends SelectableChannel>
extends AbstractChannel {
    final AbstractNioWorker worker;
    final Object writeLock = new Object();
    final Runnable writeTask = new WriteTask();
    final AtomicBoolean writeTaskInTaskQueue = new AtomicBoolean();
    final Queue<MessageEvent> writeBufferQueue = new WriteRequestQueue();
    final AtomicInteger writeBufferSize = new AtomicInteger();
    final AtomicInteger highWaterMarkCounter = new AtomicInteger();
    MessageEvent currentWriteEvent;
    SocketSendBufferPool.SendBuffer currentWriteBuffer;
    boolean inWriteNowLoop;
    boolean writeSuspended;
    private volatile InetSocketAddress localAddress;
    volatile InetSocketAddress remoteAddress;
    final C channel;

    protected AbstractNioChannel(Integer id, Channel parent, ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, AbstractNioWorker worker, C ch) {
        super(id, parent, factory, pipeline, sink);
        this.worker = worker;
        this.channel = ch;
    }

    protected AbstractNioChannel(Channel parent, ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, AbstractNioWorker worker, C ch) {
        super(parent, factory, pipeline, sink);
        this.worker = worker;
        this.channel = ch;
    }

    public AbstractNioWorker getWorker() {
        return this.worker;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        InetSocketAddress localAddress = this.localAddress;
        if (localAddress == null) {
            try {
                localAddress = this.getLocalSocketAddress();
                if (localAddress.getAddress().isAnyLocalAddress()) {
                    return localAddress;
                }
                this.localAddress = localAddress;
            }
            catch (Throwable t) {
                return null;
            }
        }
        return localAddress;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        InetSocketAddress remoteAddress = this.remoteAddress;
        if (remoteAddress == null) {
            try {
                this.remoteAddress = remoteAddress = this.getRemoteSocketAddress();
            }
            catch (Throwable t) {
                return null;
            }
        }
        return remoteAddress;
    }

    @Override
    public abstract NioChannelConfig getConfig();

    @Override
    protected int getInternalInterestOps() {
        return super.getInternalInterestOps();
    }

    @Override
    protected void setInternalInterestOps(int interestOps) {
        super.setInternalInterestOps(interestOps);
    }

    @Override
    protected boolean setClosed() {
        return super.setClosed();
    }

    abstract InetSocketAddress getLocalSocketAddress() throws Exception;

    abstract InetSocketAddress getRemoteSocketAddress() throws Exception;

    private final class WriteTask
    implements Runnable {
        WriteTask() {
        }

        public void run() {
            AbstractNioChannel.this.writeTaskInTaskQueue.set(false);
            AbstractNioChannel.this.worker.writeFromTaskLoop(AbstractNioChannel.this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class WriteRequestQueue
    implements Queue<MessageEvent> {
        private final ThreadLocalBoolean notifying = new ThreadLocalBoolean();
        private final Queue<MessageEvent> queue = new ConcurrentLinkedQueue<MessageEvent>();

        @Override
        public MessageEvent remove() {
            return this.queue.remove();
        }

        @Override
        public MessageEvent element() {
            return this.queue.element();
        }

        @Override
        public MessageEvent peek() {
            return this.queue.peek();
        }

        @Override
        public int size() {
            return this.queue.size();
        }

        @Override
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        @Override
        public Iterator<MessageEvent> iterator() {
            return this.queue.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.queue.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a2) {
            return this.queue.toArray(a2);
        }

        @Override
        public boolean containsAll(Collection<?> c2) {
            return this.queue.containsAll(c2);
        }

        @Override
        public boolean addAll(Collection<? extends MessageEvent> c2) {
            return this.queue.addAll(c2);
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            return this.queue.removeAll(c2);
        }

        @Override
        public boolean retainAll(Collection<?> c2) {
            return this.queue.retainAll(c2);
        }

        @Override
        public void clear() {
            this.queue.clear();
        }

        @Override
        public boolean add(MessageEvent e2) {
            return this.queue.add(e2);
        }

        @Override
        public boolean remove(Object o2) {
            return this.queue.remove(o2);
        }

        @Override
        public boolean contains(Object o2) {
            return this.queue.contains(o2);
        }

        @Override
        public boolean offer(MessageEvent e2) {
            int highWaterMark;
            boolean success = this.queue.offer(e2);
            assert (success);
            int messageSize = this.getMessageSize(e2);
            int newWriteBufferSize = AbstractNioChannel.this.writeBufferSize.addAndGet(messageSize);
            if (newWriteBufferSize >= (highWaterMark = AbstractNioChannel.this.getConfig().getWriteBufferHighWaterMark()) && newWriteBufferSize - messageSize < highWaterMark) {
                AbstractNioChannel.this.highWaterMarkCounter.incrementAndGet();
                if (AbstractNioChannel.this.setUnwritable()) {
                    if (!AbstractNioWorker.isIoThread(AbstractNioChannel.this)) {
                        Channels.fireChannelInterestChangedLater(AbstractNioChannel.this);
                    } else if (!((Boolean)this.notifying.get()).booleanValue()) {
                        this.notifying.set(Boolean.TRUE);
                        Channels.fireChannelInterestChanged(AbstractNioChannel.this);
                        this.notifying.set(Boolean.FALSE);
                    }
                }
            }
            return true;
        }

        @Override
        public MessageEvent poll() {
            MessageEvent e2 = this.queue.poll();
            if (e2 != null) {
                int messageSize = this.getMessageSize(e2);
                int newWriteBufferSize = AbstractNioChannel.this.writeBufferSize.addAndGet(-messageSize);
                int lowWaterMark = AbstractNioChannel.this.getConfig().getWriteBufferLowWaterMark();
                if ((newWriteBufferSize == 0 || newWriteBufferSize < lowWaterMark) && newWriteBufferSize + messageSize >= lowWaterMark) {
                    AbstractNioChannel.this.highWaterMarkCounter.decrementAndGet();
                    if (AbstractNioChannel.this.isConnected() && AbstractNioChannel.this.setWritable()) {
                        if (!AbstractNioWorker.isIoThread(AbstractNioChannel.this)) {
                            Channels.fireChannelInterestChangedLater(AbstractNioChannel.this);
                        } else if (!((Boolean)this.notifying.get()).booleanValue()) {
                            this.notifying.set(Boolean.TRUE);
                            Channels.fireChannelInterestChanged(AbstractNioChannel.this);
                            this.notifying.set(Boolean.FALSE);
                        }
                    }
                }
            }
            return e2;
        }

        private int getMessageSize(MessageEvent e2) {
            Object m2 = e2.getMessage();
            if (m2 instanceof ChannelBuffer) {
                return ((ChannelBuffer)m2).readableBytes();
            }
            return 0;
        }
    }
}

