/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http;

import java.util.Iterator;
import java.util.List;
import org.jboss.netty.handler.codec.http.HttpMessage;

final class HttpCodecUtil {
    static void validateHeaderName(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        for (int i2 = 0; i2 < name.length(); ++i2) {
            char c2 = name.charAt(i2);
            if (c2 > '\u007f') {
                throw new IllegalArgumentException("name contains non-ascii character: " + name);
            }
            switch (c2) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
                case ',': 
                case ':': 
                case ';': 
                case '=': {
                    throw new IllegalArgumentException("name contains one of the following prohibited characters: =,;: \\t\\r\\n\\v\\f: " + name);
                }
            }
        }
    }

    static void validateHeaderValue(String value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        int state = 0;
        block19: for (int i2 = 0; i2 < value.length(); ++i2) {
            char c2 = value.charAt(i2);
            switch (c2) {
                case '\u000b': {
                    throw new IllegalArgumentException("value contains a prohibited character '\\v': " + value);
                }
                case '\f': {
                    throw new IllegalArgumentException("value contains a prohibited character '\\f': " + value);
                }
            }
            switch (state) {
                case 0: {
                    switch (c2) {
                        case '\r': {
                            state = 1;
                            break;
                        }
                        case '\n': {
                            state = 2;
                        }
                    }
                    continue block19;
                }
                case 1: {
                    switch (c2) {
                        case '\n': {
                            state = 2;
                            continue block19;
                        }
                    }
                    throw new IllegalArgumentException("Only '\\n' is allowed after '\\r': " + value);
                }
                case 2: {
                    switch (c2) {
                        case '\t': 
                        case ' ': {
                            state = 0;
                            continue block19;
                        }
                    }
                    throw new IllegalArgumentException("Only ' ' and '\\t' are allowed after '\\n': " + value);
                }
            }
        }
        if (state != 0) {
            throw new IllegalArgumentException("value must not end with '\\r' or '\\n':" + value);
        }
    }

    static boolean isTransferEncodingChunked(HttpMessage m2) {
        List<String> chunked = m2.headers().getAll("Transfer-Encoding");
        if (chunked.isEmpty()) {
            return false;
        }
        for (String v : chunked) {
            if (!v.equalsIgnoreCase("chunked")) continue;
            return true;
        }
        return false;
    }

    static void removeTransferEncodingChunked(HttpMessage m2) {
        List<String> values = m2.headers().getAll("Transfer-Encoding");
        if (values.isEmpty()) {
            return;
        }
        Iterator<String> valuesIt = values.iterator();
        while (valuesIt.hasNext()) {
            String value = valuesIt.next();
            if (!value.equalsIgnoreCase("chunked")) continue;
            valuesIt.remove();
        }
        if (values.isEmpty()) {
            m2.headers().remove("Transfer-Encoding");
        } else {
            m2.headers().set("Transfer-Encoding", values);
        }
    }

    static boolean isContentLengthSet(HttpMessage m2) {
        List<String> contentLength = m2.headers().getAll("Content-Length");
        return !contentLength.isEmpty();
    }

    private HttpCodecUtil() {
    }
}

