/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.LifeCycleAwareChannelHandler;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.embedder.DecoderEmbedder;
import org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpContentDecoder
extends SimpleChannelUpstreamHandler
implements LifeCycleAwareChannelHandler {
    private DecoderEmbedder<ChannelBuffer> decoder;

    protected HttpContentDecoder() {
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e2) throws Exception {
        Object msg = e2.getMessage();
        if (msg instanceof HttpResponse && ((HttpResponse)msg).getStatus().getCode() == 100) {
            ctx.sendUpstream(e2);
        } else if (msg instanceof HttpMessage) {
            boolean hasContent;
            HttpMessage m2 = (HttpMessage)msg;
            this.finishDecode();
            String contentEncoding = m2.headers().get("Content-Encoding");
            contentEncoding = contentEncoding != null ? contentEncoding.trim() : "identity";
            boolean bl = hasContent = m2.isChunked() || m2.getContent().readable();
            if (hasContent && (this.decoder = this.newContentDecoder(contentEncoding)) != null) {
                String targetContentEncoding = this.getTargetContentEncoding(contentEncoding);
                if ("identity".equals(targetContentEncoding)) {
                    m2.headers().remove("Content-Encoding");
                } else {
                    m2.headers().set("Content-Encoding", targetContentEncoding);
                }
                if (!m2.isChunked()) {
                    ChannelBuffer content = m2.getContent();
                    content = ChannelBuffers.wrappedBuffer(this.decode(content), this.finishDecode());
                    m2.setContent(content);
                    if (m2.headers().contains("Content-Length")) {
                        m2.headers().set("Content-Length", Integer.toString(content.readableBytes()));
                    }
                }
            }
            ctx.sendUpstream(e2);
        } else if (msg instanceof HttpChunk) {
            HttpChunk c2 = (HttpChunk)msg;
            ChannelBuffer content = c2.getContent();
            if (this.decoder != null) {
                if (!c2.isLast()) {
                    if ((content = this.decode(content)).readable()) {
                        c2.setContent(content);
                        ctx.sendUpstream(e2);
                    }
                } else {
                    ChannelBuffer lastProduct = this.finishDecode();
                    if (lastProduct.readable()) {
                        Channels.fireMessageReceived(ctx, (Object)new DefaultHttpChunk(lastProduct), e2.getRemoteAddress());
                    }
                    ctx.sendUpstream(e2);
                }
            } else {
                ctx.sendUpstream(e2);
            }
        } else {
            ctx.sendUpstream(e2);
        }
    }

    @Override
    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e2) throws Exception {
        this.finishDecode();
        super.channelClosed(ctx, e2);
    }

    protected abstract DecoderEmbedder<ChannelBuffer> newContentDecoder(String var1) throws Exception;

    protected String getTargetContentEncoding(String contentEncoding) throws Exception {
        return "identity";
    }

    private ChannelBuffer decode(ChannelBuffer buf) {
        this.decoder.offer(buf);
        return ChannelBuffers.wrappedBuffer(this.decoder.pollAll(new ChannelBuffer[this.decoder.size()]));
    }

    private ChannelBuffer finishDecode() {
        if (this.decoder == null) {
            return ChannelBuffers.EMPTY_BUFFER;
        }
        ChannelBuffer result = this.decoder.finish() ? ChannelBuffers.wrappedBuffer(this.decoder.pollAll(new ChannelBuffer[this.decoder.size()])) : ChannelBuffers.EMPTY_BUFFER;
        this.decoder = null;
        return result;
    }

    @Override
    public void beforeAdd(ChannelHandlerContext ctx) throws Exception {
    }

    @Override
    public void afterAdd(ChannelHandlerContext ctx) throws Exception {
    }

    @Override
    public void beforeRemove(ChannelHandlerContext ctx) throws Exception {
    }

    @Override
    public void afterRemove(ChannelHandlerContext ctx) throws Exception {
        this.finishDecode();
    }
}

