/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.LifeCycleAwareChannelHandler;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.handler.codec.embedder.EncoderEmbedder;
import org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpContentEncoder
extends SimpleChannelHandler
implements LifeCycleAwareChannelHandler {
    private final Queue<String> acceptEncodingQueue = new ConcurrentLinkedQueue<String>();
    private volatile EncoderEmbedder<ChannelBuffer> encoder;
    private volatile boolean offerred;

    protected HttpContentEncoder() {
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e2) throws Exception {
        Object msg = e2.getMessage();
        if (!(msg instanceof HttpMessage)) {
            ctx.sendUpstream(e2);
            return;
        }
        HttpMessage m2 = (HttpMessage)msg;
        String acceptedEncoding = m2.headers().get("Accept-Encoding");
        if (acceptedEncoding == null) {
            acceptedEncoding = "identity";
        }
        boolean offered = this.acceptEncodingQueue.offer(acceptedEncoding);
        assert (offered);
        ctx.sendUpstream(e2);
    }

    @Override
    public void writeRequested(ChannelHandlerContext ctx, MessageEvent e2) throws Exception {
        Object msg = e2.getMessage();
        if (msg instanceof HttpResponse && ((HttpResponse)msg).getStatus().getCode() == 100) {
            ctx.sendDownstream(e2);
        } else if (msg instanceof HttpMessage) {
            HttpMessage m2 = (HttpMessage)msg;
            this.finishEncode();
            String acceptEncoding = this.acceptEncodingQueue.poll();
            if (acceptEncoding == null) {
                throw new IllegalStateException("cannot send more responses than requests");
            }
            String contentEncoding = m2.headers().get("Content-Encoding");
            if (contentEncoding != null && !"identity".equalsIgnoreCase(contentEncoding)) {
                ctx.sendDownstream(e2);
            } else {
                boolean hasContent;
                boolean bl = hasContent = m2.isChunked() || m2.getContent().readable();
                if (hasContent && (this.encoder = this.newContentEncoder(m2, acceptEncoding)) != null) {
                    m2.headers().set("Content-Encoding", this.getTargetContentEncoding(acceptEncoding));
                    if (m2.isChunked()) {
                        m2.headers().remove("Content-Length");
                    } else {
                        ChannelBuffer content = m2.getContent();
                        content = ChannelBuffers.wrappedBuffer(this.encode(content), this.finishEncode());
                        m2.setContent(content);
                        if (m2.headers().contains("Content-Length")) {
                            m2.headers().set("Content-Length", Integer.toString(content.readableBytes()));
                        }
                    }
                }
                ctx.sendDownstream(e2);
            }
        } else if (msg instanceof HttpChunk) {
            HttpChunk c2 = (HttpChunk)msg;
            ChannelBuffer content = c2.getContent();
            if (this.encoder != null) {
                if (!c2.isLast()) {
                    if ((content = this.encode(content)).readable()) {
                        c2.setContent(content);
                        ctx.sendDownstream(e2);
                    }
                } else {
                    ChannelBuffer lastProduct = this.finishEncode();
                    if (lastProduct.readable()) {
                        Channels.write(ctx, Channels.succeededFuture(e2.getChannel()), new DefaultHttpChunk(lastProduct), e2.getRemoteAddress());
                    }
                    ctx.sendDownstream(e2);
                }
            } else {
                ctx.sendDownstream(e2);
            }
        } else {
            ctx.sendDownstream(e2);
        }
    }

    @Override
    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e2) throws Exception {
        this.finishEncode();
        super.channelClosed(ctx, e2);
    }

    protected abstract EncoderEmbedder<ChannelBuffer> newContentEncoder(HttpMessage var1, String var2) throws Exception;

    protected abstract String getTargetContentEncoding(String var1) throws Exception;

    private ChannelBuffer encode(ChannelBuffer buf) {
        this.offerred = true;
        this.encoder.offer(buf);
        return ChannelBuffers.wrappedBuffer(this.encoder.pollAll(new ChannelBuffer[this.encoder.size()]));
    }

    private ChannelBuffer finishEncode() {
        if (this.encoder == null) {
            this.offerred = false;
            return ChannelBuffers.EMPTY_BUFFER;
        }
        if (!this.offerred) {
            this.offerred = false;
            this.encoder.offer(ChannelBuffers.EMPTY_BUFFER);
        }
        ChannelBuffer result = this.encoder.finish() ? ChannelBuffers.wrappedBuffer(this.encoder.pollAll(new ChannelBuffer[this.encoder.size()])) : ChannelBuffers.EMPTY_BUFFER;
        this.encoder = null;
        return result;
    }

    @Override
    public void beforeAdd(ChannelHandlerContext ctx) throws Exception {
    }

    @Override
    public void afterAdd(ChannelHandlerContext ctx) throws Exception {
    }

    @Override
    public void beforeRemove(ChannelHandlerContext ctx) throws Exception {
    }

    @Override
    public void afterRemove(ChannelHandlerContext ctx) throws Exception {
        this.finishEncode();
    }
}

